/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.client.auth.ntlm.av;

/**
 * Represents the AV_PAIR structure for single host information in NTLM authentication. This class extends {@code AvPair} to
 * handle single host data, which includes custom data and a unique machine ID.
 *
 * <p>
 * This implementation is based on the jcifs library, available at:
 * <a href="https://github.com/codelibs/jcifs">https://github.com/codelibs/jcifs</a>
 * </p>
 *
 * @see <a href="https://github.com/codelibs/jcifs">jcifs on GitHub</a>
 */
public class AvSingleHost extends AvPair {

  /**
   * Constructs an instance of {@code AvSingleHost} with the specified raw data.
   *
   * @param raw the raw byte data representing the single host information.
   */
  public AvSingleHost(byte[] raw) {
    super(MsvAvSingleHost, raw);
  }
}
