/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.client.auth.ntlm.smb;

/**
 * This class defines SMB (Server Message Block) protocol constants.
 * <p>
 * It includes the constant for the number of milliseconds between the epoch time (1970) and the NT epoch time (1601), which is
 * used in NTLM authentication and SMB protocol implementations.
 * </p>
 * <p>
 * This implementation is based on the jcifs library, available at <a href="https://github.com/kevinboone/jcifs">jcifs GitHub
 * Repository</a>.
 * </p>
 */
public class SmbConstants {

  public static final long MILLISECONDS_BETWEEN_1970_AND_1601 = 11644473600000L;
}
