/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.provider;

import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.http.api.HttpService;
import org.mule.service.http.netty.impl.service.NettyHttpServiceImplementation;

import javax.inject.Inject;

public class NettyHttpServiceProvider implements ServiceProvider {

  private SchedulerService schedulerService;

  @Override
  public ServiceDefinition getServiceDefinition() {
    NettyHttpServiceImplementation service = new NettyHttpServiceImplementation(schedulerService);
    ServiceDefinition serviceDefinition = new ServiceDefinition(HttpService.class, service);
    return serviceDefinition;
  }

  @Inject
  public void setSchedulerService(SchedulerService schedulerService) {
    this.schedulerService = schedulerService;
  }
}
