/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.common.util;

import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.domain.entity.HttpEntity;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class HttpEntityMatcher extends TypeSafeMatcher<HttpEntity> {

  public static Matcher<HttpEntity> hasContent(Matcher<String> contentStringMatcher) {
    return new HttpEntityMatcher(contentStringMatcher);
  }

  private final Matcher<String> contentStringMatcher;

  private HttpEntityMatcher(Matcher<String> contentStringMatcher) {
    this.contentStringMatcher = contentStringMatcher;
  }

  @Override
  protected boolean matchesSafely(HttpEntity item) {
    var contentAsString = IOUtils.toString(item.getContent());
    return contentStringMatcher.matches(contentAsString);
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("A content matching: ");
    contentStringMatcher.describeTo(description);
  }

  @Override
  protected void describeMismatchSafely(HttpEntity item, Description mismatchDescription) {
    var contentAsString = IOUtils.toString(item.getContent());
    mismatchDescription.appendText("Content was: '").appendText(contentAsString).appendText("'");
  }
}
