/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.netty.utils;

import static org.mule.runtime.http.api.HttpConstants.HttpStatus.OK;

import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.service.http.netty.impl.message.content.StringHttpEntity;

public class TestHttp2RequestHandler implements RequestHandler {

  @Override
  public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
    responseCallback.responseReady(new ResponseWithoutHeaders(OK, new StringHttpEntity("Test body")),
                                   new NoOpResponseStatusCallback());
  }
}
