/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.transport;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.concurrent.Executor;

public final class NativeChannelTransportSpecifics {
    private static final String TRY_USING_NATIVE_PROP = "mule.http.service.tryUseNative";
    private static final boolean TRY_USING_NATIVE = Boolean.getBoolean("mule.http.service.tryUseNative");

    private NativeChannelTransportSpecifics() {
    }

    public static EventLoopGroup createLoopGroup(int threadsCount, Executor executor) {
        if (TRY_USING_NATIVE && Epoll.isAvailable()) {
            return new EpollEventLoopGroup(threadsCount, executor);
        }
        return new NioEventLoopGroup(threadsCount, executor);
    }

    public static Class<? extends DatagramChannel> getDatagramChannelType() {
        if (TRY_USING_NATIVE && Epoll.isAvailable()) {
            return EpollDatagramChannel.class;
        }
        return NioDatagramChannel.class;
    }

    public static Class<? extends ServerChannel> getServerChannelType() {
        if (TRY_USING_NATIVE && Epoll.isAvailable()) {
            return EpollServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public static boolean triesUsingNative() {
        return TRY_USING_NATIVE;
    }
}

