/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.client;

import io.qameta.allure.Story;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.netty.utils.TestUtils;
import org.mule.tck.junit4.rule.DynamicPort;

@Story(value="Timeouts")
public class ClientTcpConnectionTimeoutTestCase
extends AbstractHttpServiceTestCase {
    private static final Integer CLIENT_CONNECTION_TIMEOUT_MILLIS = 1;
    @Rule
    public DynamicPort tcpServerPort = new DynamicPort("tcpServerPort");
    private HttpClient client;

    public ClientTcpConnectionTimeoutTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void setup() {
        TcpClientSocketProperties withConnectionTimeout = TcpClientSocketProperties.builder().connectionTimeout(CLIENT_CONNECTION_TIMEOUT_MILLIS).build();
        HttpClientConfiguration clientConfig = new HttpClientConfiguration.Builder().setName("client-with-connection-timeout").setClientSocketProperties(withConnectionTimeout).build();
        this.client = this.service.getClientFactory().create(clientConfig);
        this.client.start();
    }

    @After
    public void tearDown() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Test
    public void clientTcpConnectionTimeout() throws Exception {
        Assume.assumeThat((Object)SystemUtils.IS_OS_MAC, (Matcher)Matchers.is((Object)true));
        try (ServerSocket serverSocket = new ServerSocket(this.tcpServerPort.getNumber(), 1);
             Socket auxClientSocket = new Socket("localhost", this.tcpServerPort.getNumber());){
            HttpRequest request = HttpRequest.builder().uri("http://localhost:" + this.tcpServerPort.getNumber()).build();
            long elapsedNanos = TestUtils.measuringNanoseconds(() -> {
                IOException error = (IOException)Assert.assertThrows(IOException.class, () -> this.client.send(request));
                MatcherAssert.assertThat((Object)error, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsStringIgnoringCase((String)"timeout")));
            });
            long expectedTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(CLIENT_CONNECTION_TIMEOUT_MILLIS.intValue());
            long toleranceNanos = TimeUnit.SECONDS.toNanos(1L);
            MatcherAssert.assertThat((Object)elapsedNanos, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(expectedTimeoutNanos + toleranceNanos)));
        }
    }
}

