/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty;

import java.net.InetSocketAddress;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.service.http.netty.impl.server.AcceptedConnectionChannelInitializer;
import org.mule.service.http.netty.impl.server.NettyHttpServer;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;

public class SseExample {
    public static void main(String[] args) throws Exception {
        HttpServer server = SseExample.getHttpServer();
        server.start();
        server.sse("/sse", sseSender -> {
            try {
                for (int i = 0; i < 10; ++i) {
                    sseSender.sendEvent("name1", String.format("Hello %d", i));
                    sseSender.sendEvent("name2", String.format("Hello %d", i));
                    System.out.println("SseSender sent: " + i);
                    Thread.sleep(1000L);
                }
                sseSender.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        System.in.read();
        server.stop().dispose();
    }

    private static HttpServer getHttpServer() {
        HttpListenerRegistry listenerRegistry = new HttpListenerRegistry();
        return NettyHttpServer.builder().withServerAddress(new InetSocketAddress(8081)).withHttpListenerRegistry(listenerRegistry).withShutdownTimeout(() -> 5000L).withClientChannelHandler(new AcceptedConnectionChannelInitializer(listenerRegistry, true, 30000, 10000L, null)).build();
    }
}

