/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableCauseMatcher;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.netty.impl.client.NettyHttpClient;
import org.mule.service.http.netty.utils.server.HardcodedResponseTcpServer;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import reactor.netty.http.client.PrematureCloseException;

public class ClientResponseStreamingTestCase
extends AbstractMuleTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    @Rule
    public HardcodedResponseTcpServer server = new HardcodedResponseTcpServer(this.serverPort.getNumber());
    private HttpClient client;

    @Before
    public void setUp() throws Exception {
        this.server.setResponse("HTTP/1.1 200 OK\ntransfer-encoding: chunked\n\n1\nA");
        this.server.setCloseOutputAfterResponse(true);
        this.client = NettyHttpClient.builder().build();
        this.client.start();
    }

    @After
    public void tearDown() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Test
    public void propagateErrorDuringResponseStreamingToReader() throws IOException, TimeoutException {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().method("GET").uri(String.format("http://localhost:%d/hello", this.serverPort.getNumber())).entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpResponse response = this.client.send(httpRequest);
        HttpEntity entity = response.getEntity();
        MatcherAssert.assertThat((String)"Response entity must be streaming", (Object)entity.isStreaming(), (Matcher)Matchers.is((Object)true));
        InputStream inputStream = entity.getContent();
        IOException exception = (IOException)Assert.assertThrows(IOException.class, () -> {
            boolean eosReached = false;
            while (!eosReached) {
                eosReached = inputStream.read() == -1;
            }
        });
        MatcherAssert.assertThat((Object)exception, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(PrematureCloseException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"Connection prematurely closed DURING response")))));
    }
}

