/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server.sse;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.runtime.http.api.sse.server.SseRequestContext;
import org.mule.service.http.netty.impl.server.sse.FutureCompleterCallback;

public class SseRequestContextImpl
implements SseRequestContext {
    private final HttpRequest request;
    private final HttpResponseReadyCallback responseCallback;
    private String clientId = null;
    private boolean rejectResponseSent;

    public SseRequestContextImpl(HttpRequest request, HttpResponseReadyCallback responseCallback) {
        this.request = request;
        this.responseCallback = responseCallback;
        this.rejectResponseSent = false;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public void setClientId(String overrideId) {
        this.clientId = overrideId;
    }

    public CompletableFuture<Void> reject(int statusCode, String reasonPhrase) {
        HttpResponse response = ((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(statusCode)).reasonPhrase(reasonPhrase).addHeader("Connection", "close")).build();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.rejectResponseSent = true;
        this.responseCallback.responseReady(response, (ResponseStatusCallback)new FutureCompleterCallback(future));
        return future;
    }

    public boolean isResponded() {
        return this.rejectResponseSent;
    }

    public Optional<String> getClientId() {
        return Optional.ofNullable(this.clientId);
    }
}

