/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.auth.ntlm;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Base64;
import jcifs.ntlmssp.Type3Message;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.service.http.netty.impl.client.auth.ntlm.NtlmMessageFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class NtlmMessageFactoryTestCase
extends AbstractMuleTestCase {
    private static final String TEST_DOMAIN = "someDomain";
    private static final String TEST_WORKSTATION = "workstation";
    private static final String TEST_USERNAME = "username";
    private static final String TEST_PASSWORD = "sup3rStr0ngP4ssw0rd";
    private static final String TYPE_2_CHALLENGE_BASE64 = "TlRMTVNTUAACAAAAAAAAACgAAAABggAAU3J2Tm9uY2UAAAAAAAAAAA==";
    private static final byte[] TYPE_2_MESSAGE_RAW = Base64.getDecoder().decode("TlRMTVNTUAACAAAAAAAAACgAAAABggAAU3J2Tm9uY2UAAAAAAAAAAA==");

    @Test
    public void generateType1AlwaysReturnTheSame() {
        NtlmMessageFactory ntlmMessageFactory = new NtlmMessageFactory(TEST_DOMAIN, TEST_WORKSTATION, TEST_USERNAME, TEST_PASSWORD);
        byte[] first = ntlmMessageFactory.createType1Message();
        byte[] second = ntlmMessageFactory.createType1Message();
        NtlmMessageFactory anotherEngine = new NtlmMessageFactory(TEST_DOMAIN, TEST_WORKSTATION, TEST_USERNAME, TEST_PASSWORD);
        byte[] third = anotherEngine.createType1Message();
        MatcherAssert.assertThat((Object)second, (Matcher)Matchers.is((Object)first));
        MatcherAssert.assertThat((Object)third, (Matcher)Matchers.is((Object)first));
    }

    @Test
    public void generateType3HasTheSpecifiedFields() throws GeneralSecurityException, IOException {
        NtlmMessageFactory ntlmMessageFactory = new NtlmMessageFactory(TEST_DOMAIN, TEST_WORKSTATION, TEST_USERNAME, TEST_PASSWORD);
        byte[] type3MessageRaw = ntlmMessageFactory.createType3Message(TYPE_2_MESSAGE_RAW);
        Type3Message type3Message = new Type3Message(type3MessageRaw);
        MatcherAssert.assertThat((Object)type3Message.getDomain(), (Matcher)Matchers.is((Object)TEST_DOMAIN));
        MatcherAssert.assertThat((Object)type3Message.getWorkstation(), (Matcher)Matchers.is((Object)TEST_WORKSTATION));
        MatcherAssert.assertThat((Object)type3Message.getUser(), (Matcher)Matchers.is((Object)TEST_USERNAME));
    }
}

