/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.sse;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.http.api.sse.client.SseRetryConfig;
import org.mule.service.http.netty.impl.client.sse.InternalConnectable;

public class RetryHelper {
    private final ScheduledExecutorService retryScheduler;
    private final SseRetryConfig retryConfig;
    private final InternalConnectable source;
    private Long retryDelayMillis;
    private boolean retryEnabled;
    private ScheduledFuture<?> retryFuture;

    public RetryHelper(ScheduledExecutorService retryScheduler, SseRetryConfig retryConfig, InternalConnectable source) {
        this.retryScheduler = retryScheduler;
        this.retryConfig = retryConfig;
        this.retryDelayMillis = retryConfig.initialRetryDelayMillis();
        this.source = source;
        this.retryEnabled = true;
    }

    public void setDelayIfAllowed(Long newDelay) {
        if (this.retryConfig.allowRetryDelayOverride()) {
            this.retryDelayMillis = newDelay;
        }
    }

    public boolean shouldRetryOnStreamEnd() {
        return this.retryEnabled && this.retryConfig.shouldRetryOnStreamEnd();
    }

    public void scheduleReconnection() {
        this.retryFuture = this.retryScheduler.schedule(this.source::internalConnect, (long)this.retryDelayMillis, TimeUnit.MILLISECONDS);
    }

    public boolean isRetryEnabled() {
        return this.retryEnabled;
    }

    public void setRetryEnabled(boolean retryEnabled) {
        this.retryEnabled = retryEnabled;
    }

    public void abortReties() {
        this.retryEnabled = false;
        if (null != this.retryFuture) {
            this.retryFuture.cancel(true);
        }
    }
}

