/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponse;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.server.DirectResponseSender;
import org.mule.service.http.netty.impl.server.StreamingResponseSender;
import org.mule.service.http.netty.impl.server.sse.ResponseBodyWriter;
import org.mule.service.http.netty.impl.util.MuleToNettyUtils;

public class NettyHttp1RequestReadyCallback
implements HttpResponseReadyCallback {
    private final ChannelHandlerContext ctx;
    private final HttpRequest httpRequest;
    private final ExecutorService ioExecutor;

    public NettyHttp1RequestReadyCallback(ChannelHandlerContext ctx, HttpRequest muleRequest, ExecutorService ioExecutor) {
        this.ctx = ctx;
        this.httpRequest = muleRequest;
        this.ioExecutor = ioExecutor;
    }

    public void responseReady(org.mule.runtime.http.api.domain.message.response.HttpResponse response, ResponseStatusCallback responseStatusCallback) {
        try {
            this.sendResponse(this.ctx, response, responseStatusCallback);
        }
        catch (IOException e) {
            responseStatusCallback.responseSendFailure((Throwable)e);
        }
    }

    public Writer startResponse(org.mule.runtime.http.api.domain.message.response.HttpResponse response, ResponseStatusCallback responseStatusCallback, Charset encoding) {
        HttpResponse nettyResponse = MuleToNettyUtils.adaptResponseWithoutBody(response, this.httpRequest.getProtocol());
        this.ctx.writeAndFlush((Object)nettyResponse);
        return new ResponseBodyWriter(this.ctx, encoding, responseStatusCallback);
    }

    private void sendResponse(ChannelHandlerContext ctx, org.mule.runtime.http.api.domain.message.response.HttpResponse response, ResponseStatusCallback callback) throws IOException {
        org.mule.runtime.http.api.domain.message.response.HttpResponse httpResponse = response;
        boolean isHeadMethod = this.isHeadMethod(this.httpRequest);
        if (isHeadMethod) {
            httpResponse = NettyHttp1RequestReadyCallback.buildResponseWithEmptyBody(httpResponse);
        }
        if (httpResponse.getEntity().isStreaming()) {
            new StreamingResponseSender(this.httpRequest, ctx, httpResponse, callback, this.ioExecutor).send();
        } else {
            new DirectResponseSender(this.httpRequest, ctx, httpResponse, callback).send();
        }
        if (isHeadMethod) {
            ctx.close();
        }
    }

    private static org.mule.runtime.http.api.domain.message.response.HttpResponse buildResponseWithEmptyBody(org.mule.runtime.http.api.domain.message.response.HttpResponse response) throws IOException {
        if (response.getEntity().isStreaming()) {
            response.getEntity().getContent().close();
        }
        return ((HttpResponseBuilder)new HttpResponseBuilder(response).entity((HttpEntity)new EmptyHttpEntity())).build();
    }

    private boolean isHeadMethod(HttpRequest httpRequest) {
        return "HEAD".equals(httpRequest.getMethod());
    }
}

