/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.tck;

import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.Is;

public class IsOptionalOf<T>
extends TypeSafeMatcher<Optional<T>> {
    private final Matcher<T> expectedElemMatcher;

    private IsOptionalOf(Matcher<T> expectedElemMatcher) {
        this.expectedElemMatcher = expectedElemMatcher;
    }

    protected boolean matchesSafely(Optional<T> item) {
        return item.isPresent() && this.expectedElemMatcher.matches(item.get());
    }

    public void describeTo(Description description) {
        description.appendText("an Optional that ").appendDescriptionOf(this.expectedElemMatcher);
    }

    protected void describeMismatchSafely(Optional<T> item, Description mismatchDescription) {
        if (!item.isPresent()) {
            mismatchDescription.appendText("got an empty Optional");
        } else {
            mismatchDescription.appendText("got an Optional that ");
            this.expectedElemMatcher.describeMismatch(item.get(), mismatchDescription);
        }
    }

    public static <T> IsOptionalOf<T> isOptionalOf(Matcher<T> expectedElemMatcher) {
        return new IsOptionalOf<T>(expectedElemMatcher);
    }

    public static <T> IsOptionalOf<T> isOptionalOf(T expectedValue) {
        return IsOptionalOf.isOptionalOf(Is.is(expectedValue));
    }
}

