/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.utils.sse;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.mule.runtime.http.api.sse.ServerSentEvent;

public class ServerSentEventTypeSafeMatcher
extends TypeSafeMatcher<ServerSentEvent> {
    private final String name;
    private final String data;
    private final String id;
    private final Long retryDelay;

    public static Matcher<? super ServerSentEvent> aServerSentEvent(String name, String data) {
        return new ServerSentEventTypeSafeMatcher(name, data, null, null);
    }

    public static Matcher<? super ServerSentEvent> aServerSentEvent(String name, String data, String id, Long retryDelay) {
        return new ServerSentEventTypeSafeMatcher(name, data, id, retryDelay);
    }

    private ServerSentEventTypeSafeMatcher(String name, String data, String id, Long retryDelay) {
        this.name = name;
        this.data = data;
        this.id = id;
        this.retryDelay = retryDelay;
    }

    public void describeTo(Description description) {
        description.appendText("A server-sent event with name '").appendValue((Object)this.name).appendText("'").appendText(", with data '").appendValue((Object)this.data).appendText("'");
        if (this.id != null) {
            description.appendText(", with id '").appendValue((Object)this.id).appendText("'");
        }
        if (this.retryDelay != null) {
            description.appendText(", with retryDelay '").appendValue((Object)this.retryDelay).appendText("'");
        }
    }

    protected boolean matchesSafely(ServerSentEvent item) {
        if (!item.getName().equals(this.name)) {
            return false;
        }
        if (!item.getData().equals(this.data)) {
            return false;
        }
        if (this.id != null) {
            if (!item.getId().isPresent()) {
                return false;
            }
            if (!((String)item.getId().get()).equals(this.id)) {
                return false;
            }
        }
        if (this.retryDelay != null) {
            if (!item.getRetryDelay().isPresent()) {
                return false;
            }
            if (!this.retryDelay.equals(item.getRetryDelay().get())) {
                return false;
            }
        }
        return true;
    }
}

