/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server.sse;

import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.mule.runtime.http.api.sse.server.SseClient;
import org.mule.service.http.netty.impl.message.sse.ServerSentEventImpl;
import org.mule.service.http.netty.impl.message.sse.SseEntityEncoder;

public class NettySseClient
implements SseClient {
    private final Writer bodyWriter;
    private final SseEntityEncoder encoder;
    private final String clientId;
    private CompletableFuture<Void> responseSentFuture;

    public NettySseClient(Writer bodyWriter, String clientId, CompletableFuture<Void> responseSentFuture) {
        this.bodyWriter = bodyWriter;
        this.responseSentFuture = responseSentFuture;
        this.encoder = new SseEntityEncoder();
        this.clientId = clientId;
    }

    public void sendEvent(String eventName, String payload, String id, Long retryDelay) throws IOException {
        this.encoder.writeTo(this.bodyWriter, new ServerSentEventImpl(eventName, payload, id, retryDelay));
    }

    public void sendComment(String comment) {
    }

    public void onClose(Consumer<Throwable> callback) {
        this.responseSentFuture = this.responseSentFuture.whenComplete((ignored, error) -> callback.accept((Throwable)error));
    }

    public void close() throws IOException {
        this.bodyWriter.close();
    }

    public String getClientId() {
        return this.clientId;
    }
}

