/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.server;

import static org.mule.runtime.http.api.HttpConstants.HttpStatus.REQUEST_TOO_LONG;

import org.mule.service.http.netty.impl.server.util.ErrorRequestHandler;

/**
 * A request handler that returns a "Request Entity Too Large" (413) error response. This handler is used when the size of the
 * request entity exceeds the server's allowed limit.
 */
public class RequestEntityTooLargeHandler extends ErrorRequestHandler {

  private static final RequestEntityTooLargeHandler instance = new RequestEntityTooLargeHandler();

  private RequestEntityTooLargeHandler() {
    super(REQUEST_TOO_LONG.getStatusCode(), REQUEST_TOO_LONG.getReasonPhrase(), "Request entity too large for '%s'");
  }

  public static RequestEntityTooLargeHandler getInstance() {
    return instance;
  }
}
