/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.message;

import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import java.io.InputStream;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.netty.impl.util.HttpResponseCreatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.netty.http.client.HttpClientResponse;

public class HttpResponseCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResponseCreator.class);
    private static final String HEADER_CONTENT_TYPE = "Content-Type".toLowerCase();
    private static final String HEADER_CONTENT_LENGTH = "Content-Length".toLowerCase();
    private static final int MAX_NUM_HEADERS_DEFAULT = 100;
    private static final String MAX_SERVER_RESPONSE_HEADERS_KEY = "mule.http.MAX_SERVER_RESPONSE_HEADERS";
    private static int MAX_SERVER_RESPONSE_HEADERS = Integer.getInteger("mule.http.MAX_SERVER_RESPONSE_HEADERS", 100);
    private final HttpResponseCreatorUtils httpResponseCreatorUtils = new HttpResponseCreatorUtils();

    private static boolean checkMaxServerResponseHeadersLimit(HttpHeaders headers) {
        if (headers.size() > MAX_SERVER_RESPONSE_HEADERS) {
            LOGGER.warn("Exceeded max server response headers limit: {}. Current header count (including default headers): {}", (Object)MAX_SERVER_RESPONSE_HEADERS, (Object)headers.size());
            return false;
        }
        return true;
    }

    public static void refreshMaxServerResponseHeaders() {
        MAX_SERVER_RESPONSE_HEADERS = Integer.getInteger(MAX_SERVER_RESPONSE_HEADERS_KEY, 100);
    }

    public static int getMaxServerResponseHeaders() {
        return MAX_SERVER_RESPONSE_HEADERS;
    }

    public org.mule.runtime.http.api.domain.message.response.HttpResponse create(HttpResponse response, InputStream inputStream) {
        HttpResponseBuilder responseBuilder = this.httpResponseCreatorUtils.buildResponseHeaders(response);
        String contentType = this.httpResponseCreatorUtils.extractHeader(response, HEADER_CONTENT_TYPE);
        String contentLength = this.httpResponseCreatorUtils.extractHeader(response, HEADER_CONTENT_LENGTH);
        responseBuilder.entity(this.httpResponseCreatorUtils.createEntity(inputStream, contentType, contentLength, response.status().code()));
        return responseBuilder.build();
    }

    public org.mule.runtime.http.api.domain.message.response.HttpResponse create(HttpClientResponse response, InputStream inputStream) {
        if (!HttpResponseCreator.checkMaxServerResponseHeadersLimit(response.responseHeaders())) {
            throw new IllegalArgumentException("Exceeded max server response headers limit: " + MAX_SERVER_RESPONSE_HEADERS);
        }
        HttpResponseBuilder responseBuilder = this.httpResponseCreatorUtils.buildResponseHeaders(response);
        String contentType = this.httpResponseCreatorUtils.extractHeader(response, HEADER_CONTENT_TYPE);
        String contentLength = this.httpResponseCreatorUtils.extractHeader(response, HEADER_CONTENT_LENGTH);
        responseBuilder.entity(this.httpResponseCreatorUtils.createEntity(inputStream, contentType, contentLength, response.status().code()));
        return responseBuilder.build();
    }
}

