/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.utils;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import org.junit.Assert;
import org.junit.function.ThrowingRunnable;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.server.HttpServerProperties;

public final class TestUtils {
    private TestUtils() {
    }

    public static void preservingHeaderCase(Runnable runnable) {
        System.setProperty("org.glassfish.grizzly.http.PRESERVE_HEADER_CASE", "true");
        HttpServerProperties.refreshSystemProperties();
        try {
            runnable.run();
        }
        finally {
            System.clearProperty("org.glassfish.grizzly.http.PRESERVE_HEADER_CASE");
            HttpServerProperties.refreshSystemProperties();
        }
    }

    public static String sendRawRequestToServer(String rawRequestToSend, String host, int port) throws IOException {
        try (Socket clientSocket = new Socket(host, port);){
            clientSocket.getOutputStream().write(rawRequestToSend.getBytes());
            byte[] responseBuffer = new byte[1024];
            clientSocket.getInputStream().read(responseBuffer);
            String string = new String(responseBuffer);
            return string;
        }
    }

    public static SslContext createServerSslContext() throws NoSuchAlgorithmException, KeyManagementException, CreateException {
        TlsContextFactory tlsContextFactory = TlsContextFactory.builder().enabledCipherSuites("TLS_SOMETHING").enabledProtocols("TLSv1.1").keyStorePath("serverKeystore").keyStorePassword("mulepassword").keyAlias("muleserver").keyPassword("mulepassword").keyStoreAlgorithm("PKIX").trustStorePath("trustStore").trustStorePassword("mulepassword").trustStoreType("jceks").insecureTrustStore(true).build();
        return new JdkSslContext(tlsContextFactory.createSslContext(), false, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}), ClientAuth.NONE, null, false);
    }

    public static long measuringNanoseconds(ThrowingRunnable runnable) {
        long nanosBefore = System.nanoTime();
        try {
            runnable.run();
        }
        catch (Throwable t) {
            Assert.fail((String)("Unexpected exception: " + String.valueOf(t)));
        }
        long nanosAfter = System.nanoTime();
        return nanosAfter - nanosBefore;
    }
}

