/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.utils;

import io.qameta.allure.Issue;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.service.http.netty.impl.server.util.HttpParser;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class HttpParserTestCase
extends AbstractMuleTestCase {
    @Test
    @Issue(value="W-17843326")
    public void testParseMultipartContent_validContent() throws IOException {
        String contentType = "multipart/mixed; boundary=boundary";
        String multipartContent = "--boundary\r\nContent-Disposition: form-data; name=\"part1\"\r\n\r\npart1 content\r\n--boundary\r\nContent-Disposition: form-data; name=\"part2\"\r\n\r\npart2 content\r\n--boundary--";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(multipartContent.getBytes());
        Collection parts = HttpParser.parseMultipartContent((InputStream)inputStream, (String)contentType);
        MatcherAssert.assertThat((Object)parts.size(), (Matcher)Matchers.is((Object)2));
        HttpPart part1 = parts.stream().filter(part -> part.getName().equals("part1")).findFirst().orElse(null);
        MatcherAssert.assertThat((Object)part1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)part1.getName(), (Matcher)Matchers.is((Object)"part1"));
        HttpPart part2 = parts.stream().filter(part -> part.getName().equals("part2")).findFirst().orElse(null);
        MatcherAssert.assertThat((Object)part2, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)part2.getName(), (Matcher)Matchers.is((Object)"part2"));
    }

    @Test
    @Issue(value="W-17843326")
    public void testParseMultipartContent_invalidContentType() {
        String invalidContentType = "text/plain";
        String invalidMultipartContent = "Invalid content";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(invalidMultipartContent.getBytes());
        Assert.assertThrows(IOException.class, () -> HttpParser.parseMultipartContent((InputStream)inputStream, (String)invalidContentType));
    }

    @Test
    @Issue(value="W-17843326")
    public void testParseMultipartContent_missingBoundary() {
        String contentType = "multipart/mixed";
        String missingBoundaryContent = "No boundary specified";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(missingBoundaryContent.getBytes());
        Assert.assertThrows(IOException.class, () -> HttpParser.parseMultipartContent((InputStream)inputStream, (String)contentType));
    }

    @Test
    @Issue(value="W-17843326")
    public void testParseMultipartContent_withMultipartRelatedAndContentId() throws IOException, MessagingException {
        String contentType = "multipart/related; boundary=boundary";
        String multipartContent = "--boundary\r\nContent-Disposition: form-data; name=\"part1\"\r\n\r\npart1 content\r\n--boundary\r\nContent-Disposition: form-data; name=\"part2\"\r\n\r\npart2 content\r\n--boundary--";
        BodyPart mockPart = (BodyPart)Mockito.mock(BodyPart.class);
        Mockito.when((Object)mockPart.getFileName()).thenReturn(null);
        Mockito.when((Object)mockPart.getContentType()).thenReturn((Object)"multipart/related; boundary=boundary");
        Mockito.when((Object)mockPart.getHeader("Content-ID")).thenReturn((Object)new String[]{"part123"});
        ByteArrayInputStream inputStream = new ByteArrayInputStream(multipartContent.getBytes());
        Collection parts = HttpParser.parseMultipartContent((InputStream)inputStream, (String)contentType);
        MatcherAssert.assertThat((Object)parts.size(), (Matcher)Matchers.is((Object)2));
        HttpPart part = parts.stream().filter(p -> p.getName().equals("part1")).findFirst().orElse(null);
        MatcherAssert.assertThat((Object)part, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)part.getName(), (Matcher)Matchers.is((Object)"part1"));
    }
}

