/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.service;

import jakarta.inject.Inject;
import java.util.Optional;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClientFactory;
import org.mule.runtime.http.api.server.HttpServerFactory;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry;
import org.mule.service.http.netty.impl.client.HttpClientConnectionManager;
import org.mule.service.http.netty.impl.server.HttpServerConnectionManager;
import org.mule.service.http.netty.impl.server.util.DefaultRequestMatcherRegistryBuilder;
import org.mule.service.http.netty.impl.service.ContextHttpClientFactory;
import org.mule.service.http.netty.impl.service.ContextHttpServerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpServiceImplementation
implements HttpService,
Startable,
Stoppable {
    private final HttpServerConnectionManager serverConnectionManager;
    private final HttpClientConnectionManager clientConnectionManager;
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyHttpServiceImplementation.class);

    public NettyHttpServiceImplementation(SchedulerService schedulerService) {
        this(schedulerService, new HttpServerConnectionManager(schedulerService), new HttpClientConnectionManager(schedulerService));
    }

    protected NettyHttpServiceImplementation(SchedulerService schedulerService, HttpServerConnectionManager serverConnectionManager, HttpClientConnectionManager clientConnectionManager) {
        this.serverConnectionManager = serverConnectionManager;
        this.clientConnectionManager = clientConnectionManager;
    }

    public HttpServerFactory getServerFactory() {
        return new ContextHttpServerFactory(this.serverConnectionManager, "container", null, () -> 1000L);
    }

    @Inject
    public HttpServerFactory getServerFactory(MuleConfiguration muleConfiguration, Registry registry) {
        Optional appName = registry.lookupByName("app.name");
        Optional domainName = registry.lookupByName("domain.name");
        ArtifactType artifactType = muleConfiguration.getArtifactType();
        String systemName = muleConfiguration.getSystemName();
        String currentCtxId = this.getCurrentContextName(artifactType, appName.orElse(null), domainName.orElse(null), systemName);
        String parentCtxId = this.getParentContextName(artifactType, domainName.orElse(null));
        return new ContextHttpServerFactory(this.serverConnectionManager, currentCtxId, parentCtxId, () -> ((MuleConfiguration)muleConfiguration).getShutdownTimeout());
    }

    private String getParentContextName(ArtifactType artifactType, String domainName) {
        if (ArtifactType.APP == artifactType && domainName != null) {
            return domainName + "-" + ArtifactType.DOMAIN.getArtifactTypeAsString();
        }
        return null;
    }

    private String getCurrentContextName(ArtifactType artifactType, String appName, String domainName, String systemName) {
        if (appName == null && domainName == null) {
            return systemName;
        }
        if (ArtifactType.APP == artifactType || ArtifactType.POLICY == artifactType) {
            return appName + "-" + artifactType.getArtifactTypeAsString();
        }
        if (ArtifactType.DOMAIN == artifactType) {
            return domainName + "-" + ArtifactType.DOMAIN.getArtifactTypeAsString();
        }
        return systemName;
    }

    public HttpClientFactory getClientFactory() {
        return new ContextHttpClientFactory(this.clientConnectionManager);
    }

    public RequestMatcherRegistry.RequestMatcherRegistryBuilder getRequestMatcherRegistryBuilder() {
        return new DefaultRequestMatcherRegistryBuilder();
    }

    public String getName() {
        return "HTTP Service using Netty";
    }

    public void start() throws MuleException {
        LifecycleUtils.initialiseIfNeeded((Object)this.serverConnectionManager);
        LifecycleUtils.initialiseIfNeeded((Object)this.clientConnectionManager);
    }

    public void stop() throws MuleException {
        LifecycleUtils.disposeIfNeeded((Object)this.serverConnectionManager, (Logger)LOGGER);
        LifecycleUtils.disposeIfNeeded((Object)this.clientConnectionManager, (Logger)LOGGER);
    }
}

