/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.server;

import static io.netty.handler.codec.http2.Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME;
import static io.netty.util.AsciiString.contentEquals;

import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;

import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;

class UpgradeToHttp2CleartextCodecFactory implements HttpServerUpgradeHandler.UpgradeCodecFactory {

  private final HttpListenerRegistry httpListenerRegistry;

  public UpgradeToHttp2CleartextCodecFactory(HttpListenerRegistry httpListenerRegistry) {
    this.httpListenerRegistry = httpListenerRegistry;
  }

  @Override
  public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
    if (contentEquals(HTTP_UPGRADE_PROTOCOL_NAME, protocol)) {
      return new Http2ServerUpgradeCodec(
                                         Http2FrameCodecBuilder.forServer().build(),
                                         new Http2MultiplexHandler(new MultiplexerChannelInitializer(httpListenerRegistry,
                                                                                                     null)));
    } else {
      return null;
    }
  }
}
