/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.common.client.sse;

import static java.lang.Math.min;
import static java.util.Arrays.fill;

import java.io.IOException;
import java.io.InputStream;

/**
 * An {@link InputStream} that generates data until a given fixed size.
 */
public class FixedSizeStream extends InputStream {

  private static final int MAGIC_BYTE = 42;

  private final int size;
  private int sent = 0;

  public FixedSizeStream(int responseSize) {
    this.size = responseSize;
  }

  @Override
  public int read() throws IOException {
    if (sent < size) {
      sent++;
      return MAGIC_BYTE;
    } else {
      return -1;
    }
  }

  @Override
  public int read(byte b[], int off, int len) throws IOException {
    len = min(len, available());
    fill(b, off, off + len, (byte) MAGIC_BYTE);
    sent += len;
    return len;
  }

  @Override
  public int available() {
    return size - sent;
  }
}
