/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.common.server;

import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.tck.junit5.DynamicPort;

import org.junit.jupiter.api.AfterEach;

public abstract class AbstractHttpServerTestCase extends AbstractHttpServiceTestCase {

  @DynamicPort(systemProperty = "port")
  protected Integer port;

  protected HttpServer server;

  public AbstractHttpServerTestCase(String serviceToLoad) {
    super(serviceToLoad);
  }

  /**
   * Sets up a server listening in localhost and the dynamic port, with a specific name and allowing further configuration.
   * Subclasses should use this in their before method.
   */
  protected void setUpServer() throws Exception {
    server = service.getServerFactory().create(configureServer(new HttpServerConfiguration.Builder()
        .setHost("localhost")
        .setPort(port)
        .setName(getServerName()))
            .build());
    server.start();
  }

  /**
   * @return the name to use for the server
   */
  protected abstract String getServerName();

  /**
   * @param builder the pre-configured builder to work with
   * @return the modified final builder to use
   */
  protected HttpServerConfiguration.Builder configureServer(HttpServerConfiguration.Builder builder) {
    return builder;
  }

  @AfterEach
  public void tearDown() {
    if (server != null) {
      server.stop();
      server.dispose();
    }
  }

  protected String urlForPath(String path) {
    return urlForPath(server, path);
  }
}
