/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.server;

import io.netty.handler.ssl.SslContext;
import io.qameta.allure.Issue;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.core5.http.ContentType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.SetSystemProperty;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.service.http.netty.impl.server.AcceptedConnectionChannelInitializer;
import org.mule.service.http.netty.impl.server.NettyHttpServer;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.common.server.AbstractHttpServerTestCase;
import org.mule.service.http.test.netty.impl.server.ServerGracefulShutdownTestCase;
import org.mule.service.http.test.netty.utils.DummyRequestHandler;
import org.mule.service.http.test.netty.utils.TestUtils;

class NettyHttpServerTestCase
extends AbstractHttpServerTestCase {
    private RequestHandlerManager requestHandlerManager;

    public NettyHttpServerTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    protected String getServerName() {
        return "test-server";
    }

    @BeforeEach
    void setup() throws Exception {
        this.setUpServer();
        this.requestHandlerManager = this.server.addRequestHandler("/path", (RequestHandler)new DummyRequestHandler());
        this.requestHandlerManager.start();
        this.server.addRequestHandler(Collections.singleton("GET"), "/only-get", (RequestHandler)new DummyRequestHandler()).start();
    }

    @Test
    void sendRequestToWrongPathResultsInAResponseWithStatusNotFound() throws ExecutionException, InterruptedException, IOException {
        try (CloseableHttpAsyncClient client = HttpAsyncClients.createDefault();){
            client.start();
            SimpleHttpRequest request = SimpleHttpRequest.create((String)"GET", (String)this.urlForPath("/not-existent"));
            SimpleHttpResponse response = (SimpleHttpResponse)client.execute(request, new AbstractHttpServiceTestCase.IgnoreFutureCallback()).get();
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.NOT_FOUND.getStatusCode()));
        }
    }

    @Test
    void twoSimpleGetRequestsToTheSamePathAreRespondedCorrectly() throws Exception {
        try (CloseableHttpAsyncClient client = HttpAsyncClients.createDefault();){
            client.start();
            SimpleHttpRequest request1 = SimpleHttpRequest.create((String)"GET", (String)this.urlForPath("/path"));
            SimpleHttpResponse response1 = (SimpleHttpResponse)client.execute(request1, new AbstractHttpServiceTestCase.IgnoreFutureCallback()).get();
            MatcherAssert.assertThat((Object)response1.getCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
            MatcherAssert.assertThat((Object)response1.getBodyText(), (Matcher)Matchers.is((Object)"Test body"));
            SimpleHttpRequest request2 = SimpleHttpRequest.create((String)"GET", (String)this.urlForPath("/path"));
            SimpleHttpResponse response2 = (SimpleHttpResponse)client.execute(request2, new AbstractHttpServiceTestCase.IgnoreFutureCallback()).get();
            MatcherAssert.assertThat((Object)response2.getCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
            MatcherAssert.assertThat((Object)response2.getBodyText(), (Matcher)Matchers.is((Object)"Test body"));
        }
    }

    @Test
    void simpleGetRequestWithInvalidHeaders() throws Exception {
        try (CloseableHttpAsyncClient client = HttpAsyncClients.createDefault();){
            client.start();
            SimpleHttpRequest request = SimpleHttpRequest.create((String)"GET", (String)this.urlForPath("/path"));
            request.addHeader("x-authentication-properties", (Object)"{\n\"key1\":\"value\"\n}");
            SimpleHttpResponse response = (SimpleHttpResponse)client.execute(request, new AbstractHttpServiceTestCase.IgnoreFutureCallback()).get();
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
            MatcherAssert.assertThat((Object)response.getBodyText(), (Matcher)Matchers.is((Object)"Test body"));
        }
    }

    @Test
    void ifTheRequestHandlerIsStoppedThenWeExpectA503() throws Exception {
        this.requestHandlerManager.stop();
        try (CloseableHttpAsyncClient client = HttpAsyncClients.createDefault();){
            client.start();
            SimpleHttpRequest request = SimpleHttpRequest.create((String)"GET", (String)this.urlForPath("/path"));
            SimpleHttpResponse response = (SimpleHttpResponse)client.execute(request, new AbstractHttpServiceTestCase.IgnoreFutureCallback()).get();
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.SERVICE_UNAVAILABLE.getStatusCode()));
        }
    }

    @Test
    void ifTheRequestHandlerIsDisposedThenWeExpectA404() throws Exception {
        this.requestHandlerManager.dispose();
        try (CloseableHttpAsyncClient client = HttpAsyncClients.createDefault();){
            client.start();
            SimpleHttpRequest request = SimpleHttpRequest.create((String)"GET", (String)this.urlForPath("/path"));
            SimpleHttpResponse response = (SimpleHttpResponse)client.execute(request, new AbstractHttpServiceTestCase.IgnoreFutureCallback()).get();
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.NOT_FOUND.getStatusCode()));
        }
    }

    @Test
    void twoSimplePostRequestsToTheSamePathAreRespondedCorrectly() throws Exception {
        try (CloseableHttpAsyncClient client = HttpAsyncClients.createDefault();){
            client.start();
            SimpleHttpRequest request1 = SimpleHttpRequest.create((String)"POST", (String)this.urlForPath("/path"));
            request1.setBody("This is a Request", ContentType.TEXT_PLAIN);
            SimpleHttpResponse response1 = (SimpleHttpResponse)client.execute(request1, new AbstractHttpServiceTestCase.IgnoreFutureCallback()).get();
            MatcherAssert.assertThat((Object)response1.getCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
            MatcherAssert.assertThat((Object)response1.getBodyText(), (Matcher)Matchers.is((Object)"Test body"));
            SimpleHttpRequest request2 = SimpleHttpRequest.create((String)"POST", (String)this.urlForPath("/path"));
            request2.setBody("This is a Request", ContentType.TEXT_PLAIN);
            SimpleHttpResponse response2 = (SimpleHttpResponse)client.execute(request2, new AbstractHttpServiceTestCase.IgnoreFutureCallback()).get();
            MatcherAssert.assertThat((Object)response2.getCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
            MatcherAssert.assertThat((Object)response2.getBodyText(), (Matcher)Matchers.is((Object)"Test body"));
        }
    }

    @Test
    void sendGetToOnlyGetEndpoint() throws Exception {
        try (CloseableHttpAsyncClient client = HttpAsyncClients.createDefault();){
            client.start();
            SimpleHttpRequest request = SimpleHttpRequest.create((String)"GET", (String)this.urlForPath("/only-get"));
            SimpleHttpResponse response = (SimpleHttpResponse)client.execute(request, new AbstractHttpServiceTestCase.IgnoreFutureCallback()).get();
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
            MatcherAssert.assertThat((Object)response.getBodyText(), (Matcher)Matchers.is((Object)"Test body"));
        }
    }

    @Test
    void sendPostToOnlyGetEndpoint() throws Exception {
        try (CloseableHttpAsyncClient client = HttpAsyncClients.createDefault();){
            client.start();
            SimpleHttpRequest request = SimpleHttpRequest.create((String)"POST", (String)this.urlForPath("/only-get"));
            request.setBody("Test payload", ContentType.TEXT_PLAIN);
            SimpleHttpResponse response = (SimpleHttpResponse)client.execute(request, new AbstractHttpServiceTestCase.IgnoreFutureCallback()).get();
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.METHOD_NOT_ALLOWED.getStatusCode()));
        }
    }

    @Test
    @Issue(value="W-15816690")
    void serverWithSslContextReturnsHttpsAsProtocol() throws Exception {
        HttpListenerRegistry listenerRegistry = new HttpListenerRegistry();
        SslContext serverSslContext = TestUtils.createServerSslContext();
        HttpServer serverWithSslContext = NettyHttpServer.builder().withName("test-server").withServerAddress(new InetSocketAddress(this.port)).withHttpListenerRegistry(listenerRegistry).withSslContext(serverSslContext).withShutdownTimeout(() -> 5000L).withClientChannelHandler(new AcceptedConnectionChannelInitializer(listenerRegistry, "test-server", "localhost", this.port.intValue(), true, 30000, 10000L, serverSslContext, (ExecutorService)ServerGracefulShutdownTestCase.executorRule.getExecutor())).build();
        MatcherAssert.assertThat((Object)serverWithSslContext.getProtocol(), (Matcher)Matchers.is((Object)HttpConstants.Protocol.HTTPS));
    }

    @Test
    @Issue(value="W-15816690")
    void serverWithoutSslContextReturnsHttpAsProtocol() {
        HttpListenerRegistry listenerRegistry = new HttpListenerRegistry();
        HttpServer serverWithoutSslContext = NettyHttpServer.builder().withName("test-server").withServerAddress(new InetSocketAddress(this.port)).withHttpListenerRegistry(listenerRegistry).withShutdownTimeout(() -> 5000L).withClientChannelHandler(new AcceptedConnectionChannelInitializer(listenerRegistry, "test-server", "localhost", this.port.intValue(), true, 30000, 10000L, null, (ExecutorService)ServerGracefulShutdownTestCase.executorRule.getExecutor())).build();
        MatcherAssert.assertThat((Object)serverWithoutSslContext.getProtocol(), (Matcher)Matchers.is((Object)HttpConstants.Protocol.HTTP));
    }

    @Test
    @Issue(value="W-15867819")
    void nonStartedServerDoesNotFailWithNPEToAddARequestHandler() {
        HttpListenerRegistry listenerRegistry = new HttpListenerRegistry();
        HttpServer notStartedServer = NettyHttpServer.builder().withName("test-server").withServerAddress(new InetSocketAddress(this.port)).withShutdownTimeout(() -> 5000L).withHttpListenerRegistry(listenerRegistry).build();
        RequestHandlerManager manager = notStartedServer.addRequestHandler("/testPath", (requestContext, responseCallback) -> {});
        MatcherAssert.assertThat((Object)manager, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    @Issue(value="W-15631509")
    @SetSystemProperty(key="mule.http.headerSectionSize", value="300")
    void getRequestWithTooLargeEntityReturns413() throws Exception {
        try (CloseableHttpAsyncClient client = HttpAsyncClients.createDefault();){
            client.start();
            SimpleHttpRequest request = SimpleHttpRequest.create((String)"GET", (String)this.urlForPath("/path"));
            for (int i = 1; i <= 20; ++i) {
                request.addHeader("testheader" + i, (Object)("testvalue" + i));
            }
            SimpleHttpResponse response = (SimpleHttpResponse)client.execute(request, new AbstractHttpServiceTestCase.IgnoreFutureCallback()).get();
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.REQUEST_TOO_LONG.getStatusCode()));
            MatcherAssert.assertThat((Object)response.getBodyText(), (Matcher)Matchers.containsString((String)"Request entity too large"));
        }
    }

    @Test
    @Issue(value="W-15631509")
    @SetSystemProperty(key="mule.http.headerSectionSize", value="300")
    void getRequestWithLongUriReturnsDetailed414() throws Exception {
        char[] chars = new char[310];
        Arrays.fill(chars, 'A');
        String longUri = "/path" + new String(chars);
        try (CloseableHttpAsyncClient client = HttpAsyncClients.createDefault();){
            client.start();
            SimpleHttpRequest request = SimpleHttpRequest.create((String)"GET", (String)this.urlForPath(longUri));
            SimpleHttpResponse response = (SimpleHttpResponse)client.execute(request, new AbstractHttpServiceTestCase.IgnoreFutureCallback()).get();
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.REQUEST_URI_TOO_LONG.getStatusCode()));
            MatcherAssert.assertThat((Object)response.getBodyText(), (Matcher)Matchers.containsString((String)"Request too long"));
        }
    }

    @Test
    @Issue(value="W-15631497")
    void testSSLConnection() throws Exception {
        String sslEndpoint = "/path";
        try (CloseableHttpAsyncClient client = HttpAsyncClients.createDefault();){
            client.start();
            SimpleHttpRequest request = SimpleHttpRequest.create((String)"GET", (String)this.urlForPath(sslEndpoint));
            SimpleHttpResponse response = (SimpleHttpResponse)client.execute(request, new AbstractHttpServiceTestCase.IgnoreFutureCallback()).get();
            MatcherAssert.assertThat((String)"Expected response status code to be 200", (Object)response.getCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
            MatcherAssert.assertThat((String)"Expected response body", (Object)response.getBodyText(), (Matcher)Matchers.is((Object)"Test body"));
        }
    }
}

