/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.netty.utils.server;

import static org.mule.service.http.test.common.util.ReflectiveServiceFactory.createHttpService;

import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.service.http.netty.impl.service.NettyHttpServiceImplementation;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;

import java.util.Collection;

import org.junit.rules.ExternalResource;

public class TestHttpServer extends ExternalResource {

  private static final String TLS_STORES_PASSWORD = "mulepassword";

  private final String host;
  private final int port;
  private final boolean useSsl;
  private HttpServer httpServer;

  public TestHttpServer(String host, int port, boolean useSsl) {
    this.host = host;
    this.port = port;
    this.useSsl = useSsl;
  }

  @Override
  protected void before() throws Throwable {
    var schedulerService = new SimpleUnitTestSupportSchedulerService();
    var httpService = createHttpService(NettyHttpServiceImplementation.class.getName(), schedulerService);

    var tlsContextFactory = useSsl ? TlsContextFactory.builder()
        .keyStorePath("serverKeystore")
        .keyStorePassword(TLS_STORES_PASSWORD)
        .keyPassword(TLS_STORES_PASSWORD)
        .build() : null;

    httpServer = httpService.getServerFactory().create(new HttpServerConfiguration.Builder()
        .setName("test-server")
        .setHost(host).setPort(port)
        .setTlsContextFactory(tlsContextFactory)
        .build());
    httpServer.start();
  }

  @Override
  protected void after() {
    httpServer.stop().dispose();
  }

  public RequestHandlerManager addRequestHandler(String path, RequestHandler requestHandler) {
    return httpServer.addRequestHandler(path, requestHandler);
  }

  public RequestHandlerManager addRequestHandler(Collection<String> methods, String path, RequestHandler requestHandler) {
    return httpServer.addRequestHandler(methods, path, requestHandler);
  }
}
