/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.benchmark;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.server.AcceptedConnectionChannelInitializer;
import org.mule.service.http.netty.impl.server.NettyHttpServer;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.test.netty.impl.benchmark.EmbeddedChannelWithAddress;
import org.mule.service.http.test.netty.utils.NoOpResponseStatusCallback;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Benchmark)
public class ServerPipelineBenchmarkState {
    private HttpServer server;
    public int port = 80;
    public EmbeddedChannel channel;
    private ByteBuf requestAsByteBuf;

    @Setup(value=Level.Trial)
    public void setUpTrial() throws IOException {
        ExecutorService pool = Executors.newFixedThreadPool(10);
        HttpListenerRegistry listenerRegistry = new HttpListenerRegistry();
        HttpServerConfiguration serverConfig = new HttpServerConfiguration.Builder().setName("BenchmarkServer").setHost("localhost").setPort(this.port).build();
        AcceptedConnectionChannelInitializer handler = new AcceptedConnectionChannelInitializer(listenerRegistry, serverConfig, null, pool);
        InetSocketAddress serverAddress = new InetSocketAddress(this.port);
        InetSocketAddress clientAddress = new InetSocketAddress(0);
        this.server = NettyHttpServer.builder().withName("BenchmarkServer").withServerAddress(serverAddress).withShutdownTimeout(() -> 5000L).withHttpListenerRegistry(listenerRegistry).withClientChannelHandler(handler).build();
        this.server.start();
        this.server.addRequestHandler("/", (request, response) -> {
            HttpResponse res = HttpResponse.builder().statusCode(Integer.valueOf(200)).reasonPhrase("OK").build();
            response.responseReady(res, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.channel = new EmbeddedChannelWithAddress(serverAddress, clientAddress, new ChannelHandler[]{handler});
        this.requestAsByteBuf = Unpooled.wrappedBuffer((byte[])"GET / HTTP/1.1\r\nContent-Length: 0\r\nHost: localhost:80\r\n\r\n".getBytes(StandardCharsets.UTF_8));
    }

    @TearDown(value=Level.Trial)
    public void tearDown() {
        ReferenceCountUtil.release((Object)this.requestAsByteBuf);
        this.channel.close();
        this.server.stop();
        this.server.dispose();
    }

    public ByteBuf getRawRequest() {
        return this.requestAsByteBuf.retainedDuplicate();
    }
}

