/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.netty;

public interface AllureConstants {

  String HTTP_SERVICE = "HTTP Service";

  interface HttpStory {

    String SERVER_MANAGEMENT = "Server Management";
    String RESPONSES = "Responses";
    String STREAMING = "Streaming";
    String PARSING = "Parsing";
    String MULTIPART = "Multipart";
    String LISTENERS = "Listeners";
    String TRANSFER_TYPE = "Transfer Type";
    String PROXIES = "Proxies";
    String CLIENT_AUTHENTICATION = "Client Authentication";
    String TLS = "TLS";
    String MAX_CONNECTIONS = "Max Connections";
    String HEADERS = "Headers";

  }

  String SSE = "Server Sent Events (SSE)";

  interface SseStory {

    String SSE_SOURCE = "SSE Source";
    String SSE_RETRY = "SSE Retry Mechanism";
    String SSE_ENDPOINT = "SSE Endpoint";
    String SSE_PROTOCOL = "SSE Protocol";

    String STREAMABLE_HTTP = "Streamable HTTP";
  }

  String HTTP_2 = "HTTP/2 Support";

  interface Http2Story {

    String HTTP_2_WITH_SSL = "HTTP/2 with SSL (h2)";
    String HTTP_2_CLEARTEXT = "HTTP/2 Cleartext (h2c)";
    String HTTP_2_CLEARTEXT_PRIOR_KNOWLEDGE = "HTTP/2 Cleartext (h2c) prior-knowledge";
    String HTTP_1_AND_2_COMPATIBILITY = "Client and server configure different combinations of HTTP/1 and HTTP/2 support";
    String HTTP_2_DEFERRED_RESPONSES = "Deferred HTTP/2 responses";
  }

  String RESOURCES_ISOLATION = "Resources isolation between applications/contexts";

  interface ResourcesIsolationStory {

    String SERVER_ISOLATION = "Server isolation between applications/contexts";
  }
}
