/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.message.sse;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.mule.runtime.http.api.sse.ServerSentEvent;
import org.mule.service.http.common.message.sse.ServerSentEventImpl;
import org.mule.service.http.common.message.sse.SseEntityEncoder;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Server Sent Events (SSE)")
@Story(value="SSE Endpoint")
public class SseEntityEncoderTestCase
extends AbstractMuleTestCase {
    public static final String THREE_LINES_DATA = "line1\nline2\nline3\n";
    private final SseEntityEncoder encoder = new SseEntityEncoder();
    private final StringWriter writer = new StringWriter();

    @Test
    public void singleLineNoOptionals() throws Exception {
        ServerSentEventImpl event = new ServerSentEventImpl("theName", "oneLineData", null, null);
        this.encoder.writeTo((Writer)this.writer, (ServerSentEvent)event);
        MatcherAssert.assertThat((Object)this.writer.toString(), (Matcher)Matchers.is((Object)"event: theName\ndata: oneLineData\n\n"));
    }

    @Test
    public void threeLinesNoOptionals() throws Exception {
        ServerSentEventImpl event = new ServerSentEventImpl("theName", THREE_LINES_DATA, null, null);
        this.encoder.writeTo((Writer)this.writer, (ServerSentEvent)event);
        MatcherAssert.assertThat((Object)this.writer.toString(), (Matcher)Matchers.is((Object)"event: theName\ndata: line1\ndata: line2\ndata: line3\n\n"));
    }

    @Test
    public void threeLinesWithAndId() throws Exception {
        ServerSentEventImpl event = new ServerSentEventImpl("theName", THREE_LINES_DATA, "theId", null);
        this.encoder.writeTo((Writer)this.writer, (ServerSentEvent)event);
        MatcherAssert.assertThat((Object)this.writer.toString(), (Matcher)Matchers.is((Object)"event: theName\ndata: line1\ndata: line2\ndata: line3\nid: theId\n\n"));
    }

    @Test
    public void threeLinesWithAndRetry() throws Exception {
        ServerSentEventImpl event = new ServerSentEventImpl("theName", THREE_LINES_DATA, null, Long.valueOf(3000L));
        this.encoder.writeTo((Writer)this.writer, (ServerSentEvent)event);
        MatcherAssert.assertThat((Object)this.writer.toString(), (Matcher)Matchers.is((Object)"event: theName\ndata: line1\ndata: line2\ndata: line3\nretry: 3000\n\n"));
    }

    @Test
    public void threeLinesIdAndRetry() throws Exception {
        ServerSentEventImpl event = new ServerSentEventImpl("theName", THREE_LINES_DATA, "theId", Long.valueOf(3000L));
        this.encoder.writeTo((Writer)this.writer, (ServerSentEvent)event);
        MatcherAssert.assertThat((Object)this.writer.toString(), (Matcher)Matchers.is((Object)"event: theName\ndata: line1\ndata: line2\ndata: line3\nid: theId\nretry: 3000\n\n"));
    }

    @Test
    public void emptyData() throws IOException {
        ServerSentEventImpl event = new ServerSentEventImpl("theName", "", null, null);
        this.encoder.writeTo((Writer)this.writer, (ServerSentEvent)event);
        MatcherAssert.assertThat((Object)this.writer.toString(), (Matcher)Matchers.is((Object)"event: theName\ndata: \n\n"));
    }

    @Test
    public void precondition_eventNameCantBeNull() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> new ServerSentEventImpl(null, "", null, null));
        MatcherAssert.assertThat((Object)exception, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.is((Object)"eventName cannot be null")));
    }

    @Test
    public void precondition_dataCantBeNull() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> new ServerSentEventImpl("theName", null, null, null));
        MatcherAssert.assertThat((Object)exception, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.is((Object)"eventData cannot be null")));
    }
}

