/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.server;

import io.qameta.allure.Issue;
import java.io.IOException;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.functional.junit4.matchers.ThrowableCauseMatcher;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.Http1ProtocolConfig;
import org.mule.runtime.http.api.Http2ProtocolConfig;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.ServerAlreadyExistsException;
import org.mule.runtime.http.api.server.ServerCreationException;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.service.http.netty.impl.server.HttpServerConnectionManager;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpServerConnectionManagerTestCase
extends AbstractMuleTestCase {
    public static final String TEST_HOST = "localhost";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port");
    private HttpServerConnectionManager httpServerConnectionManager;
    private HttpServerConfiguration mockConfiguration;
    private Supplier<HttpServerConfiguration> mockConfigurationSupplier;
    private final Supplier<Long> shutdownTimeout = () -> 5000L;

    @Before
    public void setup() {
        this.httpServerConnectionManager = new HttpServerConnectionManager(null);
        TlsContextFactory tlsContextFactory = TlsContextFactory.builder().buildDefault();
        this.mockConfigurationSupplier = (Supplier)Mockito.mock(Supplier.class);
        this.mockConfiguration = (HttpServerConfiguration)Mockito.mock(HttpServerConfiguration.class);
        Mockito.when((Object)this.mockConfiguration.getName()).thenReturn((Object)"mockServerName");
        Mockito.when((Object)this.mockConfiguration.getHost()).thenReturn((Object)TEST_HOST);
        Mockito.when((Object)this.mockConfiguration.getPort()).thenReturn((Object)this.dynamicPort.getNumber());
        Mockito.when((Object)this.mockConfiguration.getTlsContextFactory()).thenReturn((Object)tlsContextFactory);
        Mockito.when((Object)this.mockConfiguration.getHttp1Config()).thenReturn((Object)new Http1ProtocolConfig(true));
        Mockito.when((Object)this.mockConfiguration.getHttp2Config()).thenReturn((Object)new Http2ProtocolConfig(true));
        ((Supplier)Mockito.doReturn((Object)this.mockConfiguration).when(this.mockConfigurationSupplier)).get();
    }

    @Test
    public void getOrCreateServerReturnsSameInstanceIfCalledTwiceWithSameName() throws ServerCreationException {
        HttpServer firstCallServer = this.httpServerConnectionManager.getOrCreateServer("ServerName", "AppName", this.mockConfigurationSupplier, this.shutdownTimeout);
        HttpServer secondCallServer = this.httpServerConnectionManager.getOrCreateServer("ServerName", "AppName", this.mockConfigurationSupplier, this.shutdownTimeout);
        MatcherAssert.assertThat((Object)secondCallServer, (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)firstCallServer)));
    }

    @Test
    public void getOrCreateServerCallsConfigurationSupplierOnlyOnceIfCalledTwiceWithSameName() throws ServerCreationException {
        this.httpServerConnectionManager.getOrCreateServer("ServerName", "AppName", this.mockConfigurationSupplier, this.shutdownTimeout);
        this.httpServerConnectionManager.getOrCreateServer("ServerName", "AppName", this.mockConfigurationSupplier, this.shutdownTimeout);
        ((Supplier)Mockito.verify(this.mockConfigurationSupplier, (VerificationMode)Mockito.times((int)1))).get();
    }

    @Test
    public void getOrCreateServerReturnsDifferentInstancesIfCalledTwiceWithDifferentNames() throws ServerCreationException {
        HttpServer firstCallServer = this.httpServerConnectionManager.getOrCreateServer("SomeServerName", "AppName", this.mockConfigurationSupplier, this.shutdownTimeout);
        HttpServer secondCallServer = this.httpServerConnectionManager.getOrCreateServer("OtherServerName", "AppName", this.mockConfigurationSupplier, this.shutdownTimeout);
        MatcherAssert.assertThat((Object)secondCallServer, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)firstCallServer))));
    }

    @Test
    public void getOrCreateServerCallsConfigurationSupplierTwiceIfCalledTwiceWithDifferentNames() throws ServerCreationException {
        this.httpServerConnectionManager.getOrCreateServer("SomeServerName", "AppName", this.mockConfigurationSupplier, this.shutdownTimeout);
        this.httpServerConnectionManager.getOrCreateServer("OtherServerName", "AppName", this.mockConfigurationSupplier, this.shutdownTimeout);
        ((Supplier)Mockito.verify(this.mockConfigurationSupplier, (VerificationMode)Mockito.times((int)2))).get();
    }

    @Test
    public void serverNameCantBeNull() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.httpServerConnectionManager.getOrCreateServer(null, "AppName", this.mockConfigurationSupplier, this.shutdownTimeout));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"Server name can't be null"));
    }

    @Test
    public void suppliedConfigurationCantBeNull() {
        Mockito.when((Object)this.mockConfigurationSupplier.get()).thenReturn(null);
        ServerCreationException thrown = (ServerCreationException)Assertions.assertThrows(ServerCreationException.class, () -> this.httpServerConnectionManager.getOrCreateServer("SomeName", "AppName", this.mockConfigurationSupplier, this.shutdownTimeout));
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)ThrowableCauseMatcher.hasCause((Matcher)Matchers.instanceOf(IllegalArgumentException.class)));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"Could not create server: java.lang.IllegalArgumentException: Server configuration can't be null"));
    }

    @Test
    @Issue(value="W-15784799")
    public void ifAServerWasCreatedThenItCanBeLookedUp() throws ServerCreationException, ServerNotFoundException {
        this.httpServerConnectionManager.create(this.mockConfiguration, "AppName", this.shutdownTimeout);
        HttpServer lookedUp = this.httpServerConnectionManager.lookup("mockServerName", "AppName");
        MatcherAssert.assertThat((Object)lookedUp, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    @Issue(value="W-15784799")
    public void isAServerIsAlreadyCreatedThenCreatingItAgainFails() throws ServerCreationException {
        this.httpServerConnectionManager.create(this.mockConfiguration, "AppName", this.shutdownTimeout);
        String expectedErrorMessage = String.format("Could not create server: A server in port(%s) already exists for host(127.0.0.1) or one overlapping it (0.0.0.0).", this.dynamicPort.getNumber());
        ServerAlreadyExistsException thrown = (ServerAlreadyExistsException)Assertions.assertThrows(ServerAlreadyExistsException.class, () -> this.httpServerConnectionManager.create(this.mockConfiguration, "AppName", this.shutdownTimeout));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)expectedErrorMessage));
    }

    @Test
    @Issue(value="W-15795503")
    public void lifecycleCantBeAppliedIfTheServerIsLookedUp() throws ServerCreationException, ServerNotFoundException, IOException {
        HttpServer created = this.httpServerConnectionManager.create(this.mockConfiguration, "AppName", this.shutdownTimeout).start();
        HttpServer lookedUp = this.httpServerConnectionManager.lookup("mockServerName", "AppName");
        lookedUp.stop();
        MatcherAssert.assertThat((Object)created.isStopped(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)lookedUp.isStopped(), (Matcher)Matchers.is((Object)false));
        created.stop();
        MatcherAssert.assertThat((Object)created.isStopped(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)lookedUp.isStopped(), (Matcher)Matchers.is((Object)true));
    }
}

