/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.netty.impl.benchmark;

import static org.mule.runtime.http.api.server.MethodRequestMatcher.acceptAll;

import static java.util.concurrent.Executors.newCachedThreadPool;

import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.service.http.netty.impl.server.AcceptedConnectionChannelInitializer;
import org.mule.service.http.netty.impl.server.NettyHttpServer;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;

public class BenchmarkTestServer {

  private final String host;
  private final int port;
  private final HttpListenerRegistry httpListenerRegistry;

  private ExecutorService ioExecutor = newCachedThreadPool();
  private HttpServer server;

  public BenchmarkTestServer(String host, int port) {
    this.host = host;
    this.port = port;
    this.httpListenerRegistry = new HttpListenerRegistry();
  }

  public void start() throws IOException {
    ioExecutor = newCachedThreadPool();
    server = NettyHttpServer.builder().withShutdownTimeout(() -> 5000L).withServerAddress(new InetSocketAddress(host, port))
        .withHttpListenerRegistry(httpListenerRegistry)
        .withClientChannelHandler(new AcceptedConnectionChannelInitializer(httpListenerRegistry, true, 30000, 10000L, null,
                                                                           ioExecutor))
        .build();
    server.start();
  }

  public void stop() {
    if (null != server) {
      server.stop();
      server = null;
    }
    if (null != ioExecutor) {
      ioExecutor.shutdownNow();
      ioExecutor = null;
    }
  }

  public RequestHandlerManager addRequestHandler(String path, RequestHandler requestHandler) {
    return httpListenerRegistry.addRequestHandler(this.server, requestHandler,
                                                  PathAndMethodRequestMatcher.builder().methodRequestMatcher(acceptAll())
                                                      .path(path).build());
  }
}
