/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.client;

import io.qameta.allure.Description;
import io.qameta.allure.Story;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.test.common.client.AbstractHttpClientTestCase;
import org.mule.tck.probe.PollingProber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Story(value="Streaming")
@DisplayName(value="Validates cases in streaming where POST bodies are consumed more than once")
public abstract class HttpClientPostStreamingTestCase
extends AbstractHttpClientTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientPostStreamingTestCase.class);
    public static final int RESPONSE_TIMEOUT = 3000;
    private String payloadAfterDancing;
    private HttpClientConfiguration.Builder clientBuilder = new HttpClientConfiguration.Builder().setName("streaming-test");

    public HttpClientPostStreamingTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Verifies that in streaming the redirection preserves the post body and the request stream is not consumed on redirect without reset")
    void redirectionPreservesPostBody() throws Exception {
        HttpClient client = this.service.getClientFactory().create(this.clientBuilder.setResponseBufferSize(DataUnit.KB.toBytes(10)).setStreaming(true).build());
        client.start();
        try {
            HttpRequestOptions options = this.getOptions();
            HttpRequest request = this.getRequest();
            Latch responseReceivedLatch = new Latch();
            client.sendAsync(request, options).whenComplete((response, exception) -> responseReceivedLatch.release());
            responseReceivedLatch.await(3000L, TimeUnit.MILLISECONDS);
            PollingProber.probe(() -> {
                MatcherAssert.assertThat((Object)this.payloadAfterDancing, (Matcher)Is.is((Object)this.expectedPayload()));
                return true;
            });
        }
        finally {
            client.stop();
        }
    }

    protected String expectedPayload() {
        return "test";
    }

    public abstract HttpRequest getRequest();

    public abstract HttpRequestOptions getOptions();

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        return this.doSetUpHttpResponse(request);
    }

    public abstract HttpResponse doSetUpHttpResponse(HttpRequest var1);

    protected void extractPayload(HttpRequest request) {
        try {
            this.payloadAfterDancing = new String(request.getEntity().getBytes());
        }
        catch (IOException e) {
            LOGGER.debug("Could not extract payload.");
        }
    }
}

