/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.netty.tck;

import static java.util.concurrent.Executors.newScheduledThreadPool;

import java.util.concurrent.ScheduledExecutorService;

import org.junit.rules.ExternalResource;

public class ExecutorRule extends ExternalResource {

  private ScheduledExecutorService executor;

  @Override
  protected void before() throws Throwable {
    executor = newScheduledThreadPool(8);
  }

  @Override
  protected void after() {
    executor.shutdownNow();
  }

  public ScheduledExecutorService getExecutor() {
    return executor;
  }
}
