/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.auth;

import java.net.URI;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.service.http.netty.impl.client.auth.AuthUtils;

public class Realm {
    private static final String DEFAULT_NC = "00000001";
    private String opaque;
    private String algorithm;
    private String username;
    private String password;
    private String realmName;
    private String nonce;
    private String cnonce;
    private URI uri;
    private String nc = "00000001";
    private String qop;
    private String response;

    public Realm(String username, String password, String realmName, String nonce, String qop, String nc, String cnonce, URI uri, String opaque, String algorithm) {
        this.username = username;
        this.password = password;
        this.realmName = realmName;
        this.nonce = nonce;
        this.qop = qop;
        this.nc = nc;
        this.cnonce = cnonce;
        this.uri = uri;
        this.opaque = opaque;
        this.algorithm = algorithm;
    }

    public Realm(String username, String password, URI uri) {
        this.username = username;
        this.password = password;
        this.uri = uri;
    }

    public CharSequence getNonce() {
        return this.nonce;
    }

    public String getResponse() {
        return this.response;
    }

    public String getRealmName() {
        return this.realmName;
    }

    private String ha1() {
        return DigestUtils.md5Hex((String)(this.username + ":" + this.realmName + ":" + this.password));
    }

    private String ha2(String digestUri, String method) {
        return DigestUtils.md5Hex((String)(method + ":" + digestUri));
    }

    private String newResponse(URI uri, String method) {
        if (uri != null) {
            String digestUri = AuthUtils.computeRealmURI(uri, false, false);
            String ha1 = this.ha1();
            String ha2 = this.ha2(digestUri, method);
            StringBuilder middlePart = new StringBuilder(this.nonce).append(':');
            if ("auth".equals(this.qop) || "auth-int".equals(this.qop)) {
                middlePart.append(this.nc).append(':').append(this.cnonce).append(':').append(this.qop);
            }
            this.response = DigestUtils.md5Hex((String)(ha1 + ":" + String.valueOf(middlePart) + ":" + ha2));
        }
        return this.response;
    }

    private void newCnonce() {
        byte[] b = new byte[8];
        ThreadLocalRandom.current().nextBytes(b);
        this.cnonce = DigestUtils.md5Hex((byte[])b);
    }

    public static Realm newRealm(Realm realm, URI uri, String methodName) {
        String response;
        Realm newRealm = new Realm(realm.username, realm.password, realm.realmName, realm.nonce, realm.qop, realm.nc, realm.cnonce, uri, realm.opaque, realm.algorithm);
        if (!StringUtils.isBlank((CharSequence)realm.nonce)) {
            newRealm.newCnonce();
            response = newRealm.newResponse(uri, methodName);
        } else {
            response = realm.response;
        }
        newRealm.setResponse(response);
        return newRealm;
    }

    public static Realm newRealm(Realm realm, String realmName, String nonce, String qop, String opaque, String algorithm, URI uri, String methodName) {
        Realm newRealm = new Realm(realm.username, realm.password, realmName, nonce, qop, realm.nc, realm.cnonce, uri, opaque, algorithm);
        String response = !StringUtils.isBlank((CharSequence)nonce) ? newRealm.newResponse(uri, methodName) : realm.response;
        newRealm.setResponse(response);
        return newRealm;
    }

    private void setResponse(String response) {
        this.response = response;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public String getQop() {
        return this.qop;
    }

    public String getNc() {
        return this.nc;
    }

    public String getCnonce() {
        return this.cnonce;
    }
}

