/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.Issue;
import org.mule.service.http.netty.impl.server.ConditionalRequestAggregator;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Issue(value="W-19285006")
class ConditionalRequestAggregatorTestCase
extends AbstractMuleTestCase {
    private final EmbeddedChannel channelWithAggregator = new EmbeddedChannel(new ChannelHandler[]{new ConditionalRequestAggregator()});

    ConditionalRequestAggregatorTestCase() {
    }

    @Test
    void aggregateWithEmptyContent() {
        DefaultHttpRequest headerPart = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "https://localhost:80/");
        this.channelWithAggregator.writeInbound(new Object[]{headerPart, LastHttpContent.EMPTY_LAST_CONTENT});
        this.channelWithAggregator.flush();
        FullHttpRequest fullRequest = (FullHttpRequest)this.channelWithAggregator.readInbound();
        MatcherAssert.assertThat((Object)fullRequest.method(), (Matcher)Matchers.is((Object)HttpMethod.GET));
        MatcherAssert.assertThat((Object)fullRequest.protocolVersion(), (Matcher)Matchers.is((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)fullRequest.uri(), (Matcher)Matchers.is((Object)"https://localhost:80/"));
        MatcherAssert.assertThat((Object)ByteBufUtil.getBytes((ByteBuf)fullRequest.content()), (Matcher)Matchers.is((Object)new byte[0]));
    }

    @Test
    void aggregateWithNonEmptyContent() {
        DefaultHttpRequest headerPart = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "https://localhost:80/");
        byte[] contentBytes = "Hello, World!".getBytes();
        DefaultLastHttpContent lastContent = new DefaultLastHttpContent(Unpooled.wrappedBuffer((byte[])contentBytes));
        this.channelWithAggregator.writeInbound(new Object[]{headerPart, lastContent});
        this.channelWithAggregator.flush();
        FullHttpRequest fullRequest = (FullHttpRequest)this.channelWithAggregator.readInbound();
        MatcherAssert.assertThat((Object)fullRequest.method(), (Matcher)Matchers.is((Object)HttpMethod.GET));
        MatcherAssert.assertThat((Object)fullRequest.protocolVersion(), (Matcher)Matchers.is((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)fullRequest.uri(), (Matcher)Matchers.is((Object)"https://localhost:80/"));
        MatcherAssert.assertThat((Object)ByteBufUtil.getBytes((ByteBuf)fullRequest.content()), (Matcher)Matchers.is((Object)contentBytes));
    }

    @Test
    void inboundFullRequestRemainsUntouched() {
        DefaultFullHttpRequest original = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "https://localhost:80/");
        this.channelWithAggregator.writeInbound(new Object[]{original});
        this.channelWithAggregator.flush();
        FullHttpRequest fullRequest = (FullHttpRequest)this.channelWithAggregator.readInbound();
        MatcherAssert.assertThat((Object)fullRequest, (Matcher)Matchers.sameInstance((Object)original));
    }

    @Test
    void failureRequestRemainsUntouched() {
        DefaultHttpRequest original = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "https://localhost:80/");
        original.setDecoderResult(DecoderResult.failure((Throwable)new RuntimeException("Expected!")));
        this.channelWithAggregator.writeInbound(new Object[]{original});
        this.channelWithAggregator.flush();
        Object afterTheAggregator = this.channelWithAggregator.readInbound();
        MatcherAssert.assertThat((Object)afterTheAggregator, (Matcher)Matchers.sameInstance((Object)original));
    }

    @Test
    void threePartsRequestIsNotAConcernOfTheAggregator() {
        DefaultHttpRequest headerPart = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "https://localhost:80/");
        DefaultHttpContent actualContent = new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])"Hello, World!".getBytes()));
        this.channelWithAggregator.writeInbound(new Object[]{headerPart, actualContent, LastHttpContent.EMPTY_LAST_CONTENT});
        this.channelWithAggregator.flush();
        Object first = this.channelWithAggregator.readInbound();
        Object second = this.channelWithAggregator.readInbound();
        Object third = this.channelWithAggregator.readInbound();
        MatcherAssert.assertThat((Object)first, (Matcher)Matchers.sameInstance((Object)headerPart));
        MatcherAssert.assertThat((Object)second, (Matcher)Matchers.sameInstance((Object)actualContent));
        MatcherAssert.assertThat((Object)third, (Matcher)Matchers.sameInstance((Object)LastHttpContent.EMPTY_LAST_CONTENT));
    }
}

