/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.client;

import io.qameta.allure.Story;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.OptionalLong;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.netty.impl.message.content.StreamedMultipartHttpEntity;
import org.mule.service.http.netty.impl.server.ForwardingToListenerHandler;
import org.mule.service.http.test.common.client.AbstractHttpClientTestCase;

@Story(value="Transfer Type")
public abstract class AbstractHttpTransferLengthTestCase
extends AbstractHttpClientTestCase {
    private static final String RESPONSE = "TEST";
    private static final String REQUEST = "tests";
    private static final String BYTE = "/byte";
    private static final String MULTIPART = "/multipart";
    private static final String STREAM = "/stream";
    private static final String CHUNKED = "/chunked";
    private static final String MULTIPART_DATA_FORMAT = "--bounds\r\nContent-Type: text/plain\r\nContent-Disposition: form-data; name=\"part1\"\r\n\r\n%s\r\n--bounds--\r\n";
    private HttpClient client;
    private final boolean isAllowPayload;
    private final boolean isAllowPayloadDefault;

    protected AbstractHttpTransferLengthTestCase(String serviceToLoad, boolean isAllowPayload) {
        super(serviceToLoad);
        this.isAllowPayload = isAllowPayload;
        this.isAllowPayloadDefault = this.setAllowPayloadForUndefinedMethod(isAllowPayload);
    }

    protected boolean setAllowPayloadForUndefinedMethod(boolean isAllowPayload) {
        boolean defaultIsAllowPayload = ForwardingToListenerHandler.ALLOW_PAYLOAD_FOR_UNDEFINED_METHODS;
        ForwardingToListenerHandler.ALLOW_PAYLOAD_FOR_UNDEFINED_METHODS = isAllowPayload;
        return defaultIsAllowPayload;
    }

    protected void restoreAllowPayloadForUndefinedMethod(boolean isAllowPayloadDefault) {
        ForwardingToListenerHandler.ALLOW_PAYLOAD_FOR_UNDEFINED_METHODS = isAllowPayloadDefault;
    }

    @BeforeEach
    public void createClient() {
        HttpClientConfiguration clientConf = new HttpClientConfiguration.Builder().setName("transfer-type-test").build();
        this.client = this.service.getClientFactory().create(clientConf);
        this.client.start();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.client != null) {
            this.client.stop();
        }
        this.restoreAllowPayloadForUndefinedMethod(this.isAllowPayloadDefault);
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        String path = request.getPath();
        HttpEntity entity = request.getEntity();
        HttpResponseBuilder builder = HttpResponse.builder();
        try {
            OptionalLong expectedRequestLength = OptionalLong.of(REQUEST.length());
            if (BYTE.equals(path)) {
                Assert.assertThat((Object)request.containsHeader("Content-Length"), (Matcher)Matchers.is((Object)true));
                Assert.assertThat((Object)entity, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(InputStreamHttpEntity.class)));
                builder.entity((HttpEntity)new ByteArrayHttpEntity(RESPONSE.getBytes()));
            } else if (MULTIPART.equals(path)) {
                Assert.assertThat((Object)request.containsHeader("Content-Length"), (Matcher)Matchers.is((Object)true));
                expectedRequestLength = OptionalLong.of(103L);
                Assert.assertThat((Object)entity, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(StreamedMultipartHttpEntity.class)));
                ((HttpResponseBuilder)builder.entity((HttpEntity)new ByteArrayHttpEntity(String.format(MULTIPART_DATA_FORMAT, RESPONSE).getBytes()))).addHeader("Content-Type", "multipart/form-data; boundary=\"bounds\"");
            } else if (STREAM.equals(path)) {
                Assert.assertThat((Object)request.containsHeader("Content-Length"), (Matcher)Matchers.is((Object)true));
                Assert.assertThat((Object)entity, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(InputStreamHttpEntity.class)));
                builder.entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(RESPONSE.getBytes()), 4L));
            } else if (CHUNKED.equals(path)) {
                Assert.assertThat((Object)request.containsHeader("Content-Length"), (Matcher)Matchers.is((Object)false));
                Assert.assertThat((Object)entity, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(InputStreamHttpEntity.class)));
                expectedRequestLength = OptionalLong.empty();
                builder.entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(RESPONSE.getBytes())));
            } else {
                Assert.assertThat((Object)request.containsHeader("Content-Length"), (Matcher)Matchers.is((Object)false));
                expectedRequestLength = OptionalLong.of(0L);
                Assert.assertThat((Object)entity, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(EmptyHttpEntity.class)));
            }
            Assert.assertThat((Object)request.getEntity().getBytesLength(), (Matcher)Matchers.is((Object)expectedRequestLength));
            return builder.build();
        }
        catch (AssertionError e) {
            return ((HttpResponseBuilder)builder.statusCode(Integer.valueOf(500)).entity((HttpEntity)new ByteArrayHttpEntity(((Throwable)((Object)e)).getMessage().getBytes()))).build();
        }
    }

    @Test
    void propagatesLengthWhenByte() throws Exception {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(this.getUri() + BYTE).entity((HttpEntity)new ByteArrayHttpEntity(REQUEST.getBytes()))).build();
        this.send(request, false, response -> {
            Assert.assertThat((Object)response.getEntity().getBytesLength().getAsLong(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)4L)));
            Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.instanceOf(InputStreamHttpEntity.class));
        });
    }

    @Test
    void propagatesLengthWhenMultipart() throws Exception {
        HttpRequest request = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(this.getUri() + MULTIPART).addHeader("Content-Type", "multipart/form-data; boundary=bounds")).entity((HttpEntity)new ByteArrayHttpEntity(String.format(MULTIPART_DATA_FORMAT, REQUEST).getBytes()))).build();
        this.send(request, false, response -> {
            Assert.assertThat((Object)response.getEntity().getBytesLength().getAsLong(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)102L)));
            Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.instanceOf(StreamedMultipartHttpEntity.class));
        });
    }

    @Test
    void propagatesLengthWhenEmpty() throws Exception {
        HttpRequest request = HttpRequest.builder().uri(this.getUri() + "/empty").build();
        this.send(request, true, response -> {
            Assert.assertThat((Object)response.getEntity().getBytesLength().getAsLong(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
            Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.instanceOf(EmptyHttpEntity.class));
        });
    }

    @Test
    void propagatesLengthWhenStream() throws Exception {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(this.getUri() + STREAM).entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(REQUEST.getBytes()), 5L))).build();
        this.send(request, false, response -> {
            Assert.assertThat((Object)response.getEntity().getBytesLength().getAsLong(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)4L)));
            Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.instanceOf(InputStreamHttpEntity.class));
        });
    }

    @Test
    void doesNotPropagateLengthWhenChunked() throws Exception {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(this.getUri() + CHUNKED).entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(REQUEST.getBytes())))).build();
        this.send(request, false, response -> {
            Assert.assertThat((Object)response.getEntity().getBytesLength(), (Matcher)Matchers.is((Object)OptionalLong.empty()));
            Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.instanceOf(InputStreamHttpEntity.class));
        });
    }

    private void send(HttpRequest request, boolean hasEmptyPayload, Consumer<HttpResponse> onSuccessResponse) throws Exception {
        HttpResponse response = this.client.send(request, this.getDefaultOptions(10000));
        if (this.isAllowPayload || hasEmptyPayload) {
            Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
            onSuccessResponse.accept(response);
        } else {
            Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode()));
        }
    }
}

