/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.netty.tck;

import static java.security.Security.removeProvider;

import java.util.HashSet;
import java.util.Set;

import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class CleanBouncyCastleProvidersExtension implements BeforeEachCallback, AfterEachCallback {

  private boolean initialized;
  private Set<String> providers;

  public CleanBouncyCastleProvidersExtension() {
    Set<String> providers = new HashSet<>();
    providers.add(BouncyCastleProvider.PROVIDER_NAME);
    providers.add(BouncyCastleJsseProvider.PROVIDER_NAME);
    this.providers = providers;
  }

  @Override
  public void beforeEach(ExtensionContext context) throws Exception {
    if (initialized) {
      throw new IllegalArgumentException("System property was already initialized");
    }

    cleanUpProviders();

    initialized = true;
  }

  protected void cleanUpProviders() {
    for (String p : providers) {
      removeProvider(p);
    }
  }

  @Override
  public void afterEach(ExtensionContext context) throws Exception {
    if (!initialized) {
      throw new IllegalArgumentException("Bouncy castle provider was not initialized");
    }

    cleanUpProviders();

    initialized = false;
  }

}
