/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.server;

import org.mule.runtime.http.api.domain.request.ServerConnection;

import java.net.InetSocketAddress;

public final class NettyServerConnection implements ServerConnection {

  private final InetSocketAddress localAddress;

  public NettyServerConnection(InetSocketAddress localAddress) {
    this.localAddress = localAddress;
  }

  @Override
  public InetSocketAddress getLocalHostAddress() {
    return localAddress;
  }
}
