/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.http2;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.internal.matchers.ThrowableCauseMatcher;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.Http1ProtocolConfig;
import org.mule.runtime.http.api.Http2ProtocolConfig;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.ServerCreationException;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.common.util.HttpMessageHeaderMatcher;
import org.mule.service.http.test.netty.utils.NoOpResponseStatusCallback;
import org.mule.tck.junit5.DynamicPort;

@Feature(value="HTTP/2 Support")
class Http2ClientServerCombinationsTestCase
extends AbstractHttpServiceTestCase {
    @DynamicPort(systemProperty="serverPort")
    Integer serverPort;
    private HttpServer httpServer;
    private HttpClient httpClient;

    public Http2ClientServerCombinationsTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @AfterEach
    void tearDown() {
        this.httpClient.stop();
        this.httpServer.stop().dispose();
    }

    @Test
    @Story(value="HTTP/2 Cleartext (h2c)")
    void http1OnlyCleartext() throws ExecutionException, InterruptedException, ServerCreationException, IOException, CreateException {
        this.httpServer = this.createServer(true, false, false);
        this.httpClient = this.createClient(true, false, false);
        HttpRequest request = HttpRequest.builder().uri("http://localhost:%d/test".formatted(this.serverPort)).build();
        HttpResponse response = (HttpResponse)this.httpClient.sendAsync(request).get();
        MatcherAssert.assertThat((Object)response, HttpMessageHeaderMatcher.hasHeader("X-Request-Protocol", "HTTP/1.1"));
    }

    @Test
    @Story(value="HTTP/2 with SSL (h2)")
    void http1OnlyWithSSL() throws ExecutionException, InterruptedException, ServerCreationException, IOException, CreateException {
        this.httpServer = this.createServer(true, false, true);
        this.httpClient = this.createClient(true, false, true);
        HttpRequest request = HttpRequest.builder().uri("https://localhost:%d/test".formatted(this.serverPort)).build();
        HttpResponse response = (HttpResponse)this.httpClient.sendAsync(request).get();
        MatcherAssert.assertThat((Object)response, HttpMessageHeaderMatcher.hasHeader("X-Request-Protocol", "HTTP/1.1"));
    }

    @Test
    @Stories(value={@Story(value="HTTP/2 Cleartext (h2c)"), @Story(value="HTTP/2 Cleartext (h2c) prior-knowledge")})
    void http2OnlyCleartext() throws ExecutionException, InterruptedException, ServerCreationException, IOException, CreateException {
        this.httpServer = this.createServer(false, true, false);
        this.httpClient = this.createClient(false, true, false);
        HttpRequest request = HttpRequest.builder().uri("http://localhost:%d/test".formatted(this.serverPort)).build();
        HttpResponse response = (HttpResponse)this.httpClient.sendAsync(request).get();
        MatcherAssert.assertThat((Object)response, HttpMessageHeaderMatcher.hasHeader("X-Request-Protocol", "HTTP/2"));
    }

    @Test
    @Story(value="HTTP/2 with SSL (h2)")
    void http2OnlyWithSSL() throws ExecutionException, InterruptedException, ServerCreationException, IOException, CreateException {
        this.httpServer = this.createServer(false, true, true);
        this.httpClient = this.createClient(false, true, true);
        HttpRequest request = HttpRequest.builder().uri("https://localhost:%d/test".formatted(this.serverPort)).build();
        HttpResponse response = (HttpResponse)this.httpClient.sendAsync(request).get();
        MatcherAssert.assertThat((Object)response, HttpMessageHeaderMatcher.hasHeader("X-Request-Protocol", "HTTP/2"));
    }

    @Test
    @Story(value="HTTP/2 Cleartext (h2c)")
    void bothProtocolsCleartext() throws ExecutionException, InterruptedException, ServerCreationException, IOException, CreateException {
        this.httpServer = this.createServer(true, true, false);
        this.httpClient = this.createClient(true, true, false);
        HttpRequest request = HttpRequest.builder().uri("http://localhost:%d/test".formatted(this.serverPort)).build();
        HttpResponse response = (HttpResponse)this.httpClient.sendAsync(request).get();
        MatcherAssert.assertThat((Object)response, HttpMessageHeaderMatcher.hasHeader("X-Request-Protocol", "HTTP/2"));
    }

    @Test
    @Story(value="HTTP/2 with SSL (h2)")
    void bothProtocolsWithSSL() throws ExecutionException, InterruptedException, ServerCreationException, IOException, CreateException {
        this.httpServer = this.createServer(true, true, true);
        this.httpClient = this.createClient(true, true, true);
        HttpRequest request = HttpRequest.builder().uri("https://localhost:%d/test".formatted(this.serverPort)).build();
        HttpResponse response = (HttpResponse)this.httpClient.sendAsync(request).get();
        MatcherAssert.assertThat((Object)response, HttpMessageHeaderMatcher.hasHeader("X-Request-Protocol", "HTTP/2"));
    }

    @Test
    @Stories(value={@Story(value="HTTP/2 Cleartext (h2c)"), @Story(value="Client and server configure different combinations of HTTP/1 and HTTP/2 support")})
    void clientBothProtocolsServerHttp1OnlyCleartext() throws ExecutionException, InterruptedException, ServerCreationException, IOException, CreateException {
        this.httpServer = this.createServer(true, false, false);
        this.httpClient = this.createClient(true, true, false);
        HttpRequest request = HttpRequest.builder().uri("http://localhost:%d/test".formatted(this.serverPort)).build();
        HttpResponse response = (HttpResponse)this.httpClient.sendAsync(request).get();
        MatcherAssert.assertThat((Object)response, HttpMessageHeaderMatcher.hasHeader("X-Request-Protocol", "HTTP/1.1"));
    }

    @Test
    @Stories(value={@Story(value="HTTP/2 with SSL (h2)"), @Story(value="Client and server configure different combinations of HTTP/1 and HTTP/2 support")})
    void clientBothProtocolsServerHttp1OnlyWithSSL() throws ExecutionException, InterruptedException, ServerCreationException, IOException, CreateException {
        this.httpServer = this.createServer(true, false, true);
        this.httpClient = this.createClient(true, true, true);
        HttpRequest request = HttpRequest.builder().uri("https://localhost:%d/test".formatted(this.serverPort)).build();
        HttpResponse response = (HttpResponse)this.httpClient.sendAsync(request).get();
        MatcherAssert.assertThat((Object)response, HttpMessageHeaderMatcher.hasHeader("X-Request-Protocol", "HTTP/1.1"));
    }

    @Test
    @Stories(value={@Story(value="HTTP/2 Cleartext (h2c)"), @Story(value="HTTP/2 Cleartext (h2c) prior-knowledge"), @Story(value="Client and server configure different combinations of HTTP/1 and HTTP/2 support")})
    @Description(value="The client will try to establish a HTTP/1 connection and then upgrade it to HTTP/2, while the server expects prior-knowledge")
    void clientBothProtocolsServerHttp2OnlyCleartext() throws ServerCreationException, IOException, CreateException {
        this.httpServer = this.createServer(false, true, false);
        this.httpClient = this.createClient(true, true, false);
        HttpRequest request = HttpRequest.builder().uri("http://localhost:%d/test".formatted(this.serverPort)).build();
        CompletableFuture future = this.httpClient.sendAsync(request);
        ExecutionException thrown = (ExecutionException)Assertions.assertThrows(ExecutionException.class, future::get);
        MatcherAssert.assertThat((Object)thrown, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"Remotely closed"))));
    }

    @Test
    @Stories(value={@Story(value="HTTP/2 with SSL (h2)"), @Story(value="HTTP/2 Cleartext (h2c) prior-knowledge"), @Story(value="Client and server configure different combinations of HTTP/1 and HTTP/2 support")})
    void clientBothProtocolsServerHttp2OnlyWithSSL() throws ExecutionException, InterruptedException, ServerCreationException, IOException, CreateException {
        this.httpServer = this.createServer(false, true, true);
        this.httpClient = this.createClient(true, true, true);
        HttpRequest request = HttpRequest.builder().uri("https://localhost:%d/test".formatted(this.serverPort)).build();
        HttpResponse response = (HttpResponse)this.httpClient.sendAsync(request).get();
        MatcherAssert.assertThat((Object)response, HttpMessageHeaderMatcher.hasHeader("X-Request-Protocol", "HTTP/2"));
    }

    @Test
    @Stories(value={@Story(value="HTTP/2 Cleartext (h2c)"), @Story(value="Client and server configure different combinations of HTTP/1 and HTTP/2 support")})
    void clientHttp1OnlyServerBothProtocolsCleartext() throws ExecutionException, InterruptedException, ServerCreationException, IOException, CreateException {
        this.httpServer = this.createServer(true, true, false);
        this.httpClient = this.createClient(true, false, false);
        HttpRequest request = HttpRequest.builder().uri("http://localhost:%d/test".formatted(this.serverPort)).build();
        HttpResponse response = (HttpResponse)this.httpClient.sendAsync(request).get();
        MatcherAssert.assertThat((Object)response, HttpMessageHeaderMatcher.hasHeader("X-Request-Protocol", "HTTP/1.1"));
    }

    @Test
    @Stories(value={@Story(value="HTTP/2 with SSL (h2)"), @Story(value="Client and server configure different combinations of HTTP/1 and HTTP/2 support")})
    void clientHttp1OnlyServerBothProtocolsWithSSL() throws ExecutionException, InterruptedException, ServerCreationException, IOException, CreateException {
        this.httpServer = this.createServer(true, true, true);
        this.httpClient = this.createClient(true, false, true);
        HttpRequest request = HttpRequest.builder().uri("https://localhost:%d/test".formatted(this.serverPort)).build();
        HttpResponse response = (HttpResponse)this.httpClient.sendAsync(request).get();
        MatcherAssert.assertThat((Object)response, HttpMessageHeaderMatcher.hasHeader("X-Request-Protocol", "HTTP/1.1"));
    }

    @Test
    @Stories(value={@Story(value="HTTP/2 Cleartext (h2c)"), @Story(value="HTTP/2 Cleartext (h2c) prior-knowledge"), @Story(value="Client and server configure different combinations of HTTP/1 and HTTP/2 support")})
    void clientHttp2OnlyServerBothProtocolsCleartext() throws ExecutionException, InterruptedException, ServerCreationException, IOException, CreateException {
        this.httpServer = this.createServer(true, true, false);
        this.httpClient = this.createClient(false, true, false);
        HttpRequest request = HttpRequest.builder().uri("http://localhost:%d/test".formatted(this.serverPort)).build();
        HttpResponse response = (HttpResponse)this.httpClient.sendAsync(request).get();
        MatcherAssert.assertThat((Object)response, HttpMessageHeaderMatcher.hasHeader("X-Request-Protocol", "HTTP/2"));
    }

    @Test
    @Stories(value={@Story(value="HTTP/2 with SSL (h2)"), @Story(value="Client and server configure different combinations of HTTP/1 and HTTP/2 support")})
    void clientHttp2OnlyServerBothProtocolsWithSSL() throws ExecutionException, InterruptedException, ServerCreationException, IOException, CreateException {
        this.httpServer = this.createServer(true, true, true);
        this.httpClient = this.createClient(false, true, true);
        HttpRequest request = HttpRequest.builder().uri("https://localhost:%d/test".formatted(this.serverPort)).build();
        HttpResponse response = (HttpResponse)this.httpClient.sendAsync(request).get();
        MatcherAssert.assertThat((Object)response, HttpMessageHeaderMatcher.hasHeader("X-Request-Protocol", "HTTP/2"));
    }

    @Test
    @Stories(value={@Story(value="HTTP/2 Cleartext (h2c)"), @Story(value="HTTP/2 Cleartext (h2c) prior-knowledge"), @Story(value="Client and server configure different combinations of HTTP/1 and HTTP/2 support")})
    void clientHttp1OnlyServerHttp2OnlyCleartext() throws ServerCreationException, IOException, CreateException {
        this.httpServer = this.createServer(false, true, false);
        this.httpClient = this.createClient(true, false, false);
        HttpRequest request = HttpRequest.builder().uri("http://localhost:%d/test".formatted(this.serverPort)).build();
        CompletableFuture future = this.httpClient.sendAsync(request);
        ExecutionException thrown = (ExecutionException)Assertions.assertThrows(ExecutionException.class, future::get);
        MatcherAssert.assertThat((Object)thrown, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"Remotely closed"))));
    }

    @Test
    @Stories(value={@Story(value="HTTP/2 with SSL (h2)"), @Story(value="Client and server configure different combinations of HTTP/1 and HTTP/2 support")})
    void clientHttp1OnlyServerHttp2OnlyWithSSL() throws ServerCreationException, IOException, CreateException {
        this.httpServer = this.createServer(false, true, true);
        this.httpClient = this.createClient(true, false, true);
        HttpRequest request = HttpRequest.builder().uri("https://localhost:%d/test".formatted(this.serverPort)).build();
        CompletableFuture future = this.httpClient.sendAsync(request);
        ExecutionException thrown = (ExecutionException)Assertions.assertThrows(ExecutionException.class, future::get);
        MatcherAssert.assertThat((Object)thrown, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"Remotely closed"))));
    }

    @Test
    @Stories(value={@Story(value="HTTP/2 Cleartext (h2c)"), @Story(value="HTTP/2 Cleartext (h2c) prior-knowledge"), @Story(value="Client and server configure different combinations of HTTP/1 and HTTP/2 support")})
    void clientHttp2OnlyServerHttp1OnlyCleartext() throws ServerCreationException, IOException, CreateException {
        this.httpServer = this.createServer(true, false, false);
        this.httpClient = this.createClient(false, true, false);
        HttpRequest request = HttpRequest.builder().uri("http://localhost:%d/test".formatted(this.serverPort)).build();
        CompletableFuture future = this.httpClient.sendAsync(request);
        ExecutionException thrown = (ExecutionException)Assertions.assertThrows(ExecutionException.class, future::get);
        MatcherAssert.assertThat((Object)thrown, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"Remotely closed"))));
    }

    @Test
    @Stories(value={@Story(value="HTTP/2 with SSL (h2)"), @Story(value="Client and server configure different combinations of HTTP/1 and HTTP/2 support")})
    void clientHttp2OnlyServerHttp1OnlyWithSSL() throws ServerCreationException, IOException, CreateException {
        this.httpServer = this.createServer(true, false, true);
        this.httpClient = this.createClient(false, true, true);
        HttpRequest request = HttpRequest.builder().uri("https://localhost:%d/test".formatted(this.serverPort)).build();
        CompletableFuture future = this.httpClient.sendAsync(request);
        ExecutionException thrown = (ExecutionException)Assertions.assertThrows(ExecutionException.class, future::get);
        MatcherAssert.assertThat((Object)thrown, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"Remotely closed"))));
    }

    private HttpClient createClient(boolean supportHttp1, boolean supportHttp2, boolean useTls) throws CreateException {
        HttpClientConfiguration.Builder configBuilder = new HttpClientConfiguration.Builder().setName("HTTP/2 Client").setHttp1Config(new Http1ProtocolConfig(supportHttp1)).setHttp2Config(new Http2ProtocolConfig(supportHttp2));
        if (useTls) {
            configBuilder.setTlsContextFactory(TlsContextFactory.builder().trustStorePath("trustStore").trustStorePassword("mulepassword").insecureTrustStore(true).build());
        }
        HttpClient client = this.service.getClientFactory().create(configBuilder.build());
        client.start();
        return client;
    }

    private HttpServer createServer(boolean supportHttp1, boolean supportHttp2, boolean useTls) throws ServerCreationException, IOException, CreateException {
        HttpServerConfiguration.Builder configBuilder = new HttpServerConfiguration.Builder().setName("HTTP/2 Server").setHost("localhost").setPort(this.serverPort.intValue()).setHttp1Config(new Http1ProtocolConfig(supportHttp1)).setHttp2Config(new Http2ProtocolConfig(supportHttp2));
        if (useTls) {
            configBuilder.setTlsContextFactory(TlsContextFactory.builder().keyStorePath("serverKeystore").keyStorePassword("mulepassword").keyAlias("muleserver").keyPassword("mulepassword").keyStoreAlgorithm("PKIX").build());
        }
        HttpServer server = this.service.getServerFactory().create(configBuilder.build());
        server.start();
        server.addRequestHandler("/test", (ctx, callback) -> callback.responseReady(((HttpResponseBuilder)HttpResponse.builder().addHeader("X-Request-Protocol", ctx.getRequest().getProtocol().asString())).build(), (ResponseStatusCallback)new NoOpResponseStatusCallback()));
        return server;
    }
}

