/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.http2;

import io.qameta.allure.Feature;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.Http2ProtocolConfig;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.ServerCreationException;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.netty.utils.NoOpResponseStatusCallback;
import org.mule.tck.junit5.DynamicPort;

@Feature(value="HTTP/2 Support")
class Http2ClientServerRequestsTestCase
extends AbstractHttpServiceTestCase {
    @DynamicPort(systemProperty="serverPort")
    Integer serverPort;
    private HttpServer httpServer;
    private HttpClient httpClient;
    private final CompletableFuture<HttpRequestContext> seenRequestCtx = new CompletableFuture();

    public Http2ClientServerRequestsTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @BeforeEach
    void setUp() throws Exception {
        this.httpServer = this.createServer();
        this.httpClient = this.createClient();
    }

    @AfterEach
    void tearDown() {
        this.httpClient.stop();
        this.httpServer.stop().dispose();
    }

    @Test
    void sendGet() throws ExecutionException, InterruptedException {
        HttpRequest request = HttpRequest.builder().uri("https://localhost:%d/test".formatted(this.serverPort)).build();
        this.httpClient.sendAsync(request).get();
        HttpRequest requestInServer = this.seenRequestCtx.get().getRequest();
        MatcherAssert.assertThat((Object)requestInServer.getMethod(), (Matcher)Matchers.is((Object)"GET"));
        MatcherAssert.assertThat((Object)requestInServer.getPath(), (Matcher)Matchers.is((Object)"/test"));
        MatcherAssert.assertThat((Object)requestInServer.getProtocol().asString(), (Matcher)Matchers.is((Object)"HTTP/2"));
    }

    @Test
    void sendGetWithQueryParams() throws ExecutionException, InterruptedException {
        HttpRequest request = HttpRequest.builder().uri("https://localhost:%d/test".formatted(this.serverPort)).addQueryParam("queryParam1", "value1.1").addQueryParam("queryParam1", "value1.2").addQueryParam("queryParam2", "value2").build();
        this.httpClient.sendAsync(request).get();
        HttpRequest requestInServer = this.seenRequestCtx.get().getRequest();
        MatcherAssert.assertThat((Object)requestInServer.getQueryParams().getAll((Object)"queryParam1"), (Matcher)Matchers.contains((Object[])new String[]{"value1.1", "value1.2"}));
        MatcherAssert.assertThat((Object)((String)requestInServer.getQueryParams().get((Object)"queryParam2")), (Matcher)Matchers.is((Object)"value2"));
    }

    @Test
    void sendGetWithHeaders() throws ExecutionException, InterruptedException {
        HttpRequest request = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri("https://localhost:%d/test".formatted(this.serverPort)).addHeader("header1", "value1")).addHeader("header2", "value2")).build();
        this.httpClient.sendAsync(request).get();
        HttpRequest requestInServer = this.seenRequestCtx.get().getRequest();
        MatcherAssert.assertThat((Object)((String)requestInServer.getHeaders().get((Object)"header1")), (Matcher)Matchers.is((Object)"value1"));
        MatcherAssert.assertThat((Object)((String)requestInServer.getHeaders().get((Object)"header2")), (Matcher)Matchers.is((Object)"value2"));
    }

    @Test
    void sendGetWithMultimapHeaders() throws ExecutionException, InterruptedException {
        HttpRequest request = ((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri("https://localhost:%d/test".formatted(this.serverPort)).addHeader("header1", "value1.1")).addHeader("header1", "value1.2")).addHeader("header2", "value2")).build();
        this.httpClient.sendAsync(request).get();
        HttpRequest requestInServer = this.seenRequestCtx.get().getRequest();
        MatcherAssert.assertThat((Object)requestInServer.getHeaders().getAll((Object)"header1"), (Matcher)Matchers.contains((Object[])new String[]{"value1.1", "value1.2"}));
        MatcherAssert.assertThat((Object)((String)requestInServer.getHeaders().get((Object)"header2")), (Matcher)Matchers.is((Object)"value2"));
    }

    private HttpClient createClient() throws CreateException {
        HttpClient client = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("HTTP/2 Client").setHttp2Config(new Http2ProtocolConfig(true)).setTlsContextFactory(TlsContextFactory.builder().trustStorePath("trustStore").trustStorePassword("mulepassword").insecureTrustStore(true).build()).build());
        client.start();
        return client;
    }

    private HttpServer createServer() throws ServerCreationException, IOException, CreateException {
        HttpServer server = this.service.getServerFactory().create(new HttpServerConfiguration.Builder().setName("HTTP/2 Server").setHost("localhost").setPort(this.serverPort.intValue()).setHttp2Config(new Http2ProtocolConfig(true)).setTlsContextFactory(TlsContextFactory.builder().keyStorePath("serverKeystore").keyStorePassword("mulepassword").keyAlias("muleserver").keyPassword("mulepassword").keyStoreAlgorithm("PKIX").build()).build());
        server.start();
        server.addRequestHandler("/test", (ctx, callback) -> {
            this.seenRequestCtx.complete(ctx);
            callback.responseReady(HttpResponse.builder().build(), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        });
        return server;
    }
}

