/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.client.proxy;

import io.netty.handler.ssl.SslContext;
import io.qameta.allure.Issue;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.proxy.NtlmProxyConfigBuilder;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.client.proxy.ProxyConfigBuilder;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.client.NettyHttpClient;
import org.mule.service.http.netty.impl.message.content.StringHttpEntity;
import org.mule.service.http.netty.impl.util.SslContextHelper;
import org.mule.service.http.test.netty.utils.HttpProxyRule;
import org.mule.service.http.test.netty.utils.NoOpResponseStatusCallback;
import org.mule.service.http.test.netty.utils.ResponseWithoutHeaders;
import org.mule.service.http.test.netty.utils.server.TestHttpServer;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@Issue(value="W-16606326")
public abstract class AbstractSimpleProxyTestCase
extends AbstractMuleTestCase {
    private static final String RESPONSE_PAYLOAD = "Hello from target server!";
    @Rule
    public DynamicPort proxyPort = new DynamicPort("proxyPort");
    @Rule
    public DynamicPort targetPort = new DynamicPort("targetPort");
    @Rule
    public TestHttpServer targetServer;
    @Rule
    public HttpProxyRule proxy;
    private final boolean useSsl;
    private SslContext sslContext;

    protected AbstractSimpleProxyTestCase(boolean useSsl) {
        this.useSsl = useSsl;
        this.targetServer = new TestHttpServer("localhost", this.targetPort.getNumber(), useSsl);
        this.proxy = new HttpProxyRule(this.proxyPort.getNumber(), this.targetPort.getNumber(), useSsl);
    }

    @Before
    public void setup() {
        this.targetServer.addRequestHandler("/hello", (request, responseSender) -> {
            StringHttpEntity helloContent = new StringHttpEntity(RESPONSE_PAYLOAD);
            responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)helloContent), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.targetServer.addRequestHandler("/hello_and_check_headers", (request, responseSender) -> {
            String proxyAuthorizationHeader = request.getRequest().getHeaderValue("Proxy-Authorization");
            if (proxyAuthorizationHeader != null) {
                Assert.fail((String)"Proxy-Authorization header should not be present");
            }
            StringHttpEntity helloContent = new StringHttpEntity(RESPONSE_PAYLOAD);
            responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)helloContent), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.sslContext = this.getSslContextIfNeeded(this.useSsl);
    }

    private SslContext getSslContextIfNeeded(boolean useSsl) {
        if (!useSsl) {
            return null;
        }
        TlsContextFactory tlsContextFactory = null;
        try {
            tlsContextFactory = TlsContextFactory.builder().trustStorePath("trustStore").trustStorePassword("mulepassword").keyStorePath("clientKeystore").keyStorePassword("mulepassword").keyPassword("mulepassword").build();
        }
        catch (CreateException e) {
            throw new RuntimeException(e);
        }
        return SslContextHelper.sslContextForClient((TlsContextFactory)tlsContextFactory, (boolean)true, (boolean)false);
    }

    @Test
    public void sendThroughProxyBasicAuth() throws IOException, TimeoutException, CreateException {
        ProxyConfig proxyConfig = ((ProxyConfigBuilder)((ProxyConfigBuilder)((ProxyConfigBuilder)((ProxyConfigBuilder)ProxyConfig.builder().host("localhost")).port(this.proxyPort.getNumber())).username("Eze")).password("NotMyActualPassword")).build();
        this.testSendThroughProxy(proxyConfig, "hello");
    }

    @Test
    public void sendThroughProxyNoAuth() throws IOException, TimeoutException, CreateException {
        ProxyConfig proxyConfig = ((ProxyConfigBuilder)((ProxyConfigBuilder)ProxyConfig.builder().host("localhost")).port(this.proxyPort.getNumber())).build();
        this.testSendThroughProxy(proxyConfig, "hello");
    }

    @Test
    public void sendThroughProxyNtlmAuth() throws IOException, TimeoutException, CreateException {
        ProxyConfig.NtlmProxyConfig proxyConfig = ((NtlmProxyConfigBuilder)((NtlmProxyConfigBuilder)((NtlmProxyConfigBuilder)((NtlmProxyConfigBuilder)ProxyConfig.NtlmProxyConfig.builder().host("localhost")).port(this.proxyPort.getNumber())).username("Eze")).password("NotMyActualPassword")).ntlmDomain("theNtlmDomain").build();
        this.testSendThroughProxy((ProxyConfig)proxyConfig, "hello");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testSendThroughProxy(ProxyConfig proxyConfig, String url) throws IOException, TimeoutException, CreateException {
        NettyHttpClient client = NettyHttpClient.builder().withSslContext(this.sslContext).withProxyConfig(proxyConfig).build();
        client.start();
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("%%s://localhost:%%d/%s".formatted(url), this.useSsl ? "https" : "http", this.targetPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        try {
            HttpResponse response = client.send(httpRequest);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)new String(response.getEntity().getBytes()), (Matcher)Matchers.is((Object)RESPONSE_PAYLOAD));
            MatcherAssert.assertThat((String)"The request has to pass through the proxy server", (Object)this.proxy.hasConnections(), (Matcher)Matchers.is((Object)true));
        }
        finally {
            client.stop();
        }
    }
}

