/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.common.server;

import static org.mule.runtime.http.api.HttpHeaders.Values.CHUNKED;

import static org.apache.commons.lang3.StringUtils.EMPTY;
import static org.apache.http.HttpVersion.HTTP_1_1;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.nullValue;

import org.apache.http.HttpVersion;
import org.junit.jupiter.api.Test;

public class HttpServerTransfer11TestCase extends HttpServerTransferTestCase {

  public HttpServerTransfer11TestCase(String serviceToLoad) {
    super(serviceToLoad);
  }

  @Override
  public HttpVersion getVersion() {
    return HTTP_1_1;
  }

  @Test
  void defaultsToLengthWhenEmpty() throws Exception {
    verifyTransferHeaders(EMPTY, is(nullValue()), is("0"), EMPTY);
  }

  @Test
  void defaultsToLengthWhenBytes() throws Exception {
    verifyTransferHeaders(BYTES, is(nullValue()), is(DATA_SIZE), DATA);
  }

  @Test
  void defaultsToLengthWhenMultipart() throws Exception {
    verifyTransferHeaders(MULTIPART, is(nullValue()), is(MULTIPART_SIZE), MULTIPART_DATA);
  }

  @Test
  void defaultsToChunkedWhenStream() throws Exception {
    verifyTransferHeaders(STREAM, is(CHUNKED), is(nullValue()), DATA);
  }

  @Test
  void usesChunkedWhenEmptyAndHeader() throws Exception {
    headerToSend = CHUNKED_PAIR;
    verifyTransferHeaders(EMPTY, is(CHUNKED), is(nullValue()), EMPTY);
  }

  @Test
  void usesChunkedWhenBytesAndHeader() throws Exception {
    headerToSend = CHUNKED_PAIR;
    verifyTransferHeaders(BYTES, is(CHUNKED), is(nullValue()), DATA);
  }

  @Test
  void usesChunkedWhenMultipartAndHeader() throws Exception {
    headerToSend = CHUNKED_PAIR;
    verifyTransferHeaders(MULTIPART, is(CHUNKED), is(nullValue()), MULTIPART_DATA);
  }

  @Test
  void usesChunkedWhenStreamAndHeader() throws Exception {
    headerToSend = CHUNKED_PAIR;
    verifyTransferHeaders(STREAM, is(CHUNKED), is(nullValue()), DATA);
  }

}
