/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.common.util;

import org.mule.runtime.http.api.domain.message.response.HttpResponse;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;

public class AsyncEntityReader implements Runnable {

  private final InputStream content;
  private final StringBuilder sink = new StringBuilder();
  private final AtomicBoolean finished = new AtomicBoolean(false);

  public AsyncEntityReader(HttpResponse response) {
    content = response.getEntity().getContent();
  }

  public String partialPayload() {
    synchronized (sink) {
      return sink.toString();
    }
  }

  @Override
  public void run() {
    byte[] buffer = new byte[1024];
    try {
      while (true) {
        int result = content.read(buffer);
        if (result == -1) {
          this.finished.set(true);
          break;
        }
        synchronized (sink) {
          var asString = new String(buffer, 0, result);
          sink.append(asString);
        }
      }
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

  public boolean finished() {
    return finished.get();
  }
}
