/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.client;

import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.ws.WebSocketCallback;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.ws.WebSocket;

import java.util.concurrent.CompletableFuture;

import io.netty.handler.ssl.SslContext;

public interface WebSocketsProvider {

  /**
   * Opens a new WebSocket by adding the proper upgrade header to the given {@code request}
   *
   * @param request    a {@link HttpRequest} to the target WebSocket endpoint
   * @param socketId   the id of the obtained socket
   * @param callback   the callback that will receive the associated socket events
   * @param sslContext the ssl context.
   * @return a future {@link WebSocket}
   */
  default CompletableFuture<WebSocket> openWebSocket(HttpRequest request,
                                                     String socketId,
                                                     WebSocketCallback callback,
                                                     SslContext sslContext) {
    return openWebSocket(request, HttpRequestOptions.builder().build(), socketId, callback, sslContext);
  }

  /**
   * Opens a new WebSocket by adding the proper upgrade header to the given {@code request}
   *
   * @param request        a {@link HttpRequest} to the target WebSocket endpoint
   * @param requestOptions the request options
   * @param socketId       the id of the obtained socket
   * @param callback       the callback that will receive the associated socket events
   * @param sslContext     the ssl context.
   * @return a future {@link WebSocket}
   */
  default CompletableFuture<WebSocket> openWebSocket(HttpRequest request,
                                                     HttpRequestOptions requestOptions,
                                                     String socketId,
                                                     WebSocketCallback callback,
                                                     SslContext sslContext) {
    throw new UnsupportedOperationException("WebSockets are only supported in Enterprise Edition");
  }
}
