/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.proxy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.service.http.netty.impl.client.proxy.ProxyAuthenticator;
import org.mule.service.http.netty.impl.message.HttpResponseCreator;
import org.mule.service.http.netty.impl.streaming.BlockingBidirectionalStream;

public class MessageForwardingProxyClientHandler
extends ChannelDuplexHandler {
    private final InetSocketAddress proxyAddress;
    private final ProxyAuthenticator proxyAuthenticator;
    private HttpRequest originalRequest = null;
    private String lastProxyAuthHeader = null;
    private HttpResponse lastResponse = null;
    private boolean isDanceFinished = false;
    private boolean suppressChannelReadComplete = false;
    private BlockingBidirectionalStream responseStream;
    private OutputStream responseOutput;
    private static final String AUTH_CUSTOM = "custom";

    public MessageForwardingProxyClientHandler(String proxyHost, int proxyPort, ProxyAuthenticator proxyAuthenticator) {
        this.proxyAuthenticator = proxyAuthenticator;
        this.proxyAddress = new InetSocketAddress(proxyHost, proxyPort);
    }

    public MessageForwardingProxyClientHandler(ProxyConfig proxyConfig) {
        this(proxyConfig.getHost(), proxyConfig.getPort(), new ProxyAuthenticator(proxyConfig));
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.isDanceFinished) {
            this.suppressChannelReadComplete = false;
            ctx.fireChannelRead(msg);
            return;
        }
        this.suppressChannelReadComplete = true;
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            if (response.status().code() == 200) {
                this.isDanceFinished = true;
                ctx.fireChannelRead(msg);
                return;
            }
            this.lastProxyAuthHeader = this.extractServerProxyAuthHeader(response);
            if (this.lastProxyAuthHeader != null) {
                this.lastResponse = response;
                this.responseStream = new BlockingBidirectionalStream();
                this.responseOutput = this.responseStream.getOutputStream();
                return;
            }
        }
        if (msg instanceof HttpContent) {
            ByteBuf contentBuf;
            HttpContent content = (HttpContent)msg;
            if (this.responseOutput != null && (contentBuf = content.content()).isReadable()) {
                try {
                    byte[] bytes = new byte[contentBuf.readableBytes()];
                    contentBuf.getBytes(contentBuf.readerIndex(), bytes);
                    this.responseOutput.write(bytes);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to capture response body", e);
                }
            }
        }
        if (msg instanceof LastHttpContent && this.lastProxyAuthHeader != null) {
            if (this.responseOutput != null) {
                this.responseOutput.close();
                this.responseOutput = null;
            }
            this.sendAuthenticatedRequestToProxy(ctx, ctx.newPromise());
            this.responseStream = null;
        }
    }

    private String extractServerProxyAuthHeader(HttpResponse response) {
        return response.headers().get((CharSequence)HttpHeaderNames.PROXY_AUTHENTICATE);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.connect((SocketAddress)this.proxyAddress, localAddress, promise);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest request;
            this.originalRequest = request = (HttpRequest)msg;
            this.sendAuthenticatedRequestToProxy(ctx, promise);
        } else {
            ctx.write(msg, promise);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        if (this.suppressChannelReadComplete) {
            this.suppressChannelReadComplete = false;
            if (!ctx.channel().config().isAutoRead()) {
                ctx.read();
            }
        } else {
            ctx.fireChannelReadComplete();
        }
    }

    private void sendAuthenticatedRequestToProxy(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.writeAndFlush((Object)this.addProxyAuthHeaderIfNeeded(this.originalRequest), promise);
    }

    private HttpRequest addProxyAuthHeaderIfNeeded(HttpRequest request) throws Exception {
        String proxyAuthorizationHeader;
        if (this.proxyAuthenticator.hasFinished()) {
            return request;
        }
        String string = proxyAuthorizationHeader = AUTH_CUSTOM.equals(this.proxyAuthenticator.getAuthScheme()) ? this.proxyAuthenticator.getNextHeader(this.nettyToMuleResponse(this.lastResponse)) : this.proxyAuthenticator.getNextHeader(this.lastProxyAuthHeader);
        if (proxyAuthorizationHeader != null) {
            request.headers().set((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, (Object)proxyAuthorizationHeader);
        }
        if (this.proxyAuthenticator.hasFinished()) {
            this.isDanceFinished = true;
        }
        return request;
    }

    private org.mule.runtime.http.api.domain.message.response.HttpResponse nettyToMuleResponse(HttpResponse response) {
        if (response == null) {
            return null;
        }
        HttpResponseCreator httpResponseCreator = new HttpResponseCreator();
        return httpResponseCreator.create(response, this.responseStream != null ? this.responseStream.getInputStream() : null);
    }
}

