/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.proxy;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.proxy.AuthHeaderFactory;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.common.util.HttpResponseStatusMatcher;
import org.mule.tck.junit5.DynamicPort;

public class CustomProxyAuthPreemptiveTestCase
extends AbstractHttpServiceTestCase {
    private static final String TEST_JSON = "{'method': 'text'}";
    @DynamicPort(systemProperty="proxyPort")
    Integer proxyPort;
    @DynamicPort(systemProperty="targetPort")
    Integer targetPort;
    private HttpClient httpClient;
    private WireMockServer proxyServer;
    private WireMockServer targetServer;

    public CustomProxyAuthPreemptiveTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @BeforeEach
    void setUp() throws Exception {
        this.targetServer = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().port(this.targetPort.intValue()));
        this.targetServer.start();
        this.targetServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/target-endpoint")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withBody(TEST_JSON)));
        this.proxyServer = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().port(this.proxyPort.intValue()).enableBrowserProxying(true));
        this.proxyServer.start();
        this.proxyServer.stubFor(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse().withStatus(407).withHeader("Proxy-Authenticate", new String[]{"Basic realm=\"Test Proxy\""})));
        this.proxyServer.stubFor(WireMock.any((UrlPattern)WireMock.anyUrl()).withHeader("Proxy-Authorization", WireMock.matching((String)"Basic dGVzdDp0ZXN0")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom("http://localhost:" + this.targetPort)));
        final AuthHeaderFactory customAuthFactory = new AuthHeaderFactory(){
            private boolean finished = false;

            public boolean hasFinished() {
                return this.finished;
            }

            public CompletableFuture<String> generateHeader(HttpResponse response) {
                return CompletableFuture.supplyAsync(() -> {
                    List authHeaders;
                    if (this.finished) {
                        return null;
                    }
                    if (response == null) {
                        this.finished = true;
                        return "Basic dGVzdDp0ZXN0";
                    }
                    if (response.getStatusCode() == 407 && response.getHeaders() != null && (authHeaders = response.getHeaders().getAll((Object)"Proxy-Authenticate")) != null && authHeaders.stream().anyMatch(header -> header != null && header.toLowerCase().startsWith("basic"))) {
                        this.finished = true;
                        return "Basic dGVzdDp0ZXN0";
                    }
                    return null;
                });
            }
        };
        ProxyConfig customProxyConfig = new ProxyConfig(){

            public String getHost() {
                return "localhost";
            }

            public int getPort() {
                return CustomProxyAuthPreemptiveTestCase.this.proxyPort;
            }

            public String getUsername() {
                return null;
            }

            public String getPassword() {
                return null;
            }

            public String getNonProxyHosts() {
                return "";
            }

            public AuthHeaderFactory getAuthHeaderFactory() {
                return customAuthFactory;
            }
        };
        this.httpClient = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("Client").setProxyConfig(customProxyConfig).setStreaming(true).build());
        this.httpClient.start();
    }

    @AfterEach
    void tearDown() {
        this.httpClient.stop();
        if (this.proxyServer != null) {
            this.proxyServer.stop();
        }
        if (this.targetServer != null) {
            this.targetServer.stop();
        }
    }

    @Test
    void proxyHttpTest() throws ExecutionException, InterruptedException, IOException {
        String uri = "http://localhost:" + this.targetPort + "/target-endpoint";
        HttpRequest request = HttpRequest.builder().uri(uri).build();
        CompletableFuture future = this.httpClient.sendAsync(request);
        HttpResponse response = (HttpResponse)future.get();
        MatcherAssert.assertThat((Object)response, HttpResponseStatusMatcher.hasStatusCode(200));
        String responseBody = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseBody, (Matcher)CoreMatchers.containsString((String)"'method': 'text'"));
        this.proxyServer.verify(WireMock.exactly((int)1), WireMock.anyRequestedFor((UrlPattern)WireMock.anyUrl()));
        this.proxyServer.verify(WireMock.anyRequestedFor((UrlPattern)WireMock.anyUrl()).withHeader("Proxy-Authorization", WireMock.matching((String)"Basic dGVzdDp0ZXN0")));
        this.targetServer.verify(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/target-endpoint")));
    }
}

