/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.common.server.sse;

import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.sse.server.SseEndpointManager;

public class SseHandlerManagerAdapter implements SseEndpointManager {

  private final RequestHandlerManager requestHandlerManager;

  public SseHandlerManagerAdapter(RequestHandlerManager requestHandlerManager) {
    this.requestHandlerManager = requestHandlerManager;
  }

  @Override
  public void stop() {
    requestHandlerManager.stop();
  }

  @Override
  public void start() {
    requestHandlerManager.start();
  }

  @Override
  public void dispose() {
    requestHandlerManager.dispose();
  }
}
