/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.common.util;

import org.mule.runtime.http.api.domain.message.response.HttpResponse;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class HttpResponseStatusMatcher extends TypeSafeMatcher<HttpResponse> {

  public static Matcher<HttpResponse> hasStatusCode(int statusCode) {
    return new HttpResponseStatusMatcher(statusCode);
  }

  private final int expectedStatus;

  public HttpResponseStatusMatcher(int expectedStatus) {
    this.expectedStatus = expectedStatus;
  }

  @Override
  protected boolean matchesSafely(HttpResponse item) {
    return item.getStatusCode() == expectedStatus;
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("Expected an HTTP Response with status: ").appendValue(expectedStatus);
  }

  @Override
  protected void describeMismatchSafely(HttpResponse item, Description mismatchDescription) {
    mismatchDescription.appendText("seen status ").appendValue(item.getStatusCode());
  }
}
