/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.client.auth;

import java.net.URI;

import org.apache.commons.lang3.StringUtils;

/**
 * Utilities for Auth handling
 */
public class AuthUtils {

  private AuthUtils() {}

  /**
   * Used to compute the Realm URI whenever we are handling DIGEST Auth
   *
   * @param uri
   * @param useAbsoluteURI
   * @param omitQuery
   * @return realmUri
   */
  public static String computeRealmURI(URI uri, boolean useAbsoluteURI, boolean omitQuery) {
    if (useAbsoluteURI) {
      return omitQuery && !StringUtils.isBlank(uri.getQuery()) ? uri.toASCIIString().split("\\?")[0] : uri.toASCIIString();
    } else {
      String path = uri.getPath();
      return omitQuery || StringUtils.isBlank(uri.getQuery()) ? path : path + '?' + uri.getQuery();
    }
  }
}
