/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.util;

import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import java.io.InputStream;
import java.util.Collection;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.netty.impl.message.content.StreamedMultipartHttpEntity;
import reactor.netty.http.client.HttpClientResponse;

public class HttpResponseCreatorUtils {
    public HttpEntity createEntity(InputStream stream, String contentType, String contentLength, int statusCode) {
        long contentLengthAsLong = this.parseContentLength(contentLength);
        if (this.isMultipartMixed(contentType)) {
            return this.createMultipartEntity(stream, contentLengthAsLong, contentType);
        }
        if (contentLengthAsLong > 0L) {
            return new InputStreamHttpEntity(stream, contentLengthAsLong);
        }
        if (contentLengthAsLong == 0L || this.isEmptyResponse(statusCode)) {
            return new EmptyHttpEntity();
        }
        return new InputStreamHttpEntity(stream);
    }

    private long parseContentLength(String contentLength) {
        return contentLength != null ? Long.parseLong(contentLength) : -1L;
    }

    private boolean isMultipartMixed(String contentType) {
        return contentType != null && contentType.startsWith(MediaType.MULTIPART_MIXED.getPrimaryType());
    }

    public HttpResponseBuilder buildResponseHeaders(HttpClientResponse response) {
        HttpResponseBuilder responseBuilder = org.mule.runtime.http.api.domain.message.response.HttpResponse.builder().statusCode(Integer.valueOf(response.status().code())).reasonPhrase(response.status().reasonPhrase());
        HttpHeaders headers = response.responseHeaders();
        if (!headers.isEmpty()) {
            headers.names().forEach(headerName -> responseBuilder.addHeaders(headerName, (Collection)headers.getAll(headerName)));
        }
        return responseBuilder;
    }

    public String extractHeader(HttpResponse response, String headerName) {
        HttpHeaders headers = response.headers();
        return headers.contains(headerName) ? headers.get(headerName) : null;
    }

    public String extractHeader(HttpClientResponse response, String headerName) {
        HttpHeaders headers = response.responseHeaders();
        return headers.contains(headerName) ? headers.get(headerName) : null;
    }

    private HttpEntity createMultipartEntity(InputStream stream, long contentLengthAsLong, String contentType) {
        return contentLengthAsLong >= 0L ? new StreamedMultipartHttpEntity(stream, contentType, contentLengthAsLong) : new StreamedMultipartHttpEntity(stream, contentType);
    }

    private boolean isEmptyResponse(int statusCode) {
        return statusCode == HttpConstants.HttpStatus.NO_CONTENT.getStatusCode() || statusCode == HttpConstants.HttpStatus.NOT_MODIFIED.getStatusCode() || statusCode == HttpConstants.HttpStatus.RESET_CONTENT.getStatusCode();
    }

    public HttpResponseBuilder buildResponseHeaders(HttpResponse response) {
        HttpResponseBuilder responseBuilder = org.mule.runtime.http.api.domain.message.response.HttpResponse.builder().statusCode(Integer.valueOf(response.status().code())).reasonPhrase(response.status().reasonPhrase());
        HttpHeaders headers = response.headers();
        if (!headers.isEmpty()) {
            headers.names().forEach(headerName -> responseBuilder.addHeaders(headerName, (Collection)headers.getAll(headerName)));
        }
        return responseBuilder;
    }
}

